/***********************************************************************

Xmegalab / XMultiKit:
XMEGA Oscilloscope and Development Kit

Gabotronics C.A.
July 2010

Copyright 2010 Gabriel Anzziani

This program is distributed under the terms of the GNU General Public License 

www.gabotronics.com
email me at: gabriel@gabotronics.com

*****************************************************************************/

#ifndef _MYGCCDEF_H
#define _MYGCCDEF_H

#include <stdint.h>

#define setbit(port, bit) ((port) |= (uint8_t)_BV(bit))
#define setbits(port, mask) ((port) |= (uint8_t)(mask))
#define clrbit(port, bit) ((port) &= (uint8_t)~_BV(bit))
#define clrbits(port, mask) ((port) &= (uint8_t)~(mask))
#define testbit(port, bit) (uint8_t)(((uint8_t)port & (uint8_t)_BV(bit)))
#define togglebit(port, bit) (port ^= (uint8_t)_BV(bit))
#define	hibyte(x) (uint8_t)(x>>8)
#define	lobyte(x) (uint8_t)(x&0x00FF)

static __inline__ void NOP (void) { __asm__ volatile ( "nop    " "\n\t" ); }

// ### ROL ### Logical Rotate Left Of Register Through Carry 
#define ASM_ROL(reg) asm volatile ("rol %0" : "=r" (reg) : "0" (reg)) 

// ### ROR ### Logical Rotate Right Of Register Through Carry 
#define ASM_ROR(reg) asm volatile ("ror %0" : "=r" (reg) : "0" (reg)) 

// Swap two bytes
#define SWAP(x,y) do { (x)=(x)^(y); (y)=(x)^(y); (x)=(x)^(y); } while(0)

// 8:8 Fixed Point Math
typedef signed int fixed;
#define int2fix(a)   (((int)(a))<<8)            // Convert char to fix
#define fix2int(a)   ((signed char)((a)>>8))    // Convert fix to char
#define float2fix(a) ((int)((a)*256.0))         // Convert float to fix
#define fix2float(a) ((float)(a)/256.0)         // Convert fix to float
#define multfix(a,b) ((int)((((long)(a))*((long)(b)))>>8)) //multiply two fixe
#define divfix(a,b)  ((int)((((long)(a))<<8)/((long)(b)))) //divide two fixed

/*// 16:16 Fixed Point Math
//Type conversions
typedef signed long fixed;
#define int2fix(a)   (((long)(a))<<16)            //Convert char to fix. a is a char
#define fix2int(a)   ((int)((a)>>16))    //Convert fix to char. a is an int(in fixed notation)
#define float2fix(a) ((long)((a)*65536.0))         //Convert float to fix. a is a float
#define fix2float(a) ((float)(a)/65536.0)         //Convert fix to float. a is an int(in fixed notation) 
#define multfix(a,b) ( (long) ( ( ((long)(a)) * ((long)(b)) )>>16)) //multiply two fixed #
#define divfix(a,b)  ((long)((((long)(a))<<16)/((long)(b)))) //divide two fixed #
*/

#endif
