/* 	Program 	LEDDISP.C
    Creation  	July 7 2003

    Gabotronics C.A.
    August 2008

    Copyright 2008 Gabriel Anzziani

    This program is distributed under the terms of the GNU General Public License 

    Compiled with Hi-Tech Compiler
	Compile with full optimization for PIC16F882                      */
	
#include	<pic.h>			// Contains pic port definitions
#include	"delay.h"		// Rutinas de retardos
typedef unsigned char byte;

// PIC ID 		Will be used to store program version
__IDLOC(0010);	// Version 1.0
/*
// Current User, ID & Melodies stored in EEPROM:
#asm
psect eedata,delta=2,abs,ovrld
	org 2100h
	db  0, 53, 42, 26, 26, 42, 53, 53, 48, 48, 59, 59, 1
#endasm*/

// PIC Configuration Word:
__CONFIG(INTIO & WDTDIS & PWRTDIS & BORDIS & LVPDIS/* & DEBUGEN*/);
// Internal oscillator
// Watchdog enabled
// Power up Timer
// Brown out reset

// Display data buffer:
// Higher 3 bits are the intensity for that column
// Lower 5 bits are pixels
byte Disp[19];

// System 3x5 (char #32 to #96) 
const byte Font[]= {
    0b00000000, // Space 0x20
    0b00000000,
    0b00000000,
    0b11111111,
    0b00000000, // !
    0b00011101,
    0b00000000,
    0b00000000,
    0b00011000, // "
    0b00000000,
    0b00000000,
    0b00000000,
    0b00011111, // #
    0b00001010,
    0b00011111,
    0b00000000,
    0b00011101, // $
    0b00011111,
    0b00010111,
    0b00000000,
    0b00010010, // %
    0b00000100,
    0b00001001,
    0b00000000,
    0b00001010, // &
    0b00010101,
    0b00000010,
    0b00000000,
    0b00000000, // '
    0b00011000,
    0b00000000,
    0b00000000,
    0b00001110, // (
    0b00010001,
    0b00000000,
    0b00000000,
    0b00010001, // )
    0b00001110,
    0b00000000,
    0b00000000,
    0b00010100, // *
    0b00001000,
    0b00010100,
    0b00000000,
    0b00001000, // +
    0b00011100,
    0b00001000,
    0b00000000,
    0b00000001, // ,
    0b00000010,
    0b00000000,
    0b00000000,
    0b00001000, // -
    0b00001000,
    0b00001000,
    0b00000000,
    0b00000001, // .
    0b11111111,
    0b11111111,
    0b00000000,
    0b00000011, // /
    0b00000100,
    0b00011000,
    0b00000000,
	0b00001110,	// 0
	0b00010001,
	0b00001110,
    0b00000000,
	0b00001000, // 1
	0b00011111,
	0b00000000,
    0b00000000,
	0b00010011, // 2
	0b00010101,
	0b00001001,
    0b00000000,
	0b00010001, // 3
	0b00010101,
	0b00001010,
    0b00000000,
	0b00011100, // 4
	0b00000100,
	0b00011111,
    0b00000000,
	0b00011101, // 5
	0b00010101,
	0b00010110,
    0b00000000,
	0b00001111, // 6
	0b00010101,
	0b00010111,
    0b00000000,
	0b00010000, // 7
	0b00010011,
	0b00011100,
    0b00000000,
	0b00001010, // 8
	0b00010101,
	0b00001010,
    0b00000000,
	0b00011101, // 9
	0b00010101,
	0b00011110,
    0b00000000,
    0b00001010, // :
    0b11111111,
    0b11111111,
    0b00000000,
    0b00000001, // ;
    0b00001010,
    0b00000000,
    0b00000000,
    0b00000100, // <
    0b00001010,
    0b00010001,
    0b00000000,
    0b00001010, // =
    0b00001010,
    0b00001010,
    0b00000000,
    0b00010001, // >
    0b00001010,
    0b00000100,
    0b00000000,
    0b00010000, // ?
    0b00010101,
    0b00001000,
    0b00000000,
    0b00011101, // @
    0b00010001,
    0b00011111,
    0b00000000,
    0b00001111, // A
    0b00010100,
    0b00010100,
    0b00001111,
    0b00011111, // B
    0b00010101,
    0b00010101,
    0b00001010,
    0b00001110, // C
    0b00010001,
    0b00010001,
    0b00010001,
    0b00011111, // D
    0b00010001,
    0b00010001,
    0b00001110,
    0b00011111, // E
    0b00010101,
    0b00010101,
    0b00010101,
    0b00011111, // F
    0b00010100,
    0b00010100,
    0b00010100,
    0b00001110, // G
    0b00010001,
    0b00010101,
    0b00010111,
    0b00011111, // H
    0b00000100,
    0b00000100,
    0b00011111,
    0b00010001, // I
    0b00011111,
    0b00010001,
    0b11111111,
    0b00000010, // J
    0b00010001,
    0b00011110,
    0b00010000,
    0b00011111, // K
    0b00000100,
    0b00001010,
    0b00010001,
    0b00011111, // L
    0b00000001,
    0b00000001,
    0b00000001,
    0b00011111, // M *
    0b00001000,
    0b00000100,
    0b00001000,
    0b00011111, // N
    0b00001000,
    0b00000100,
    0b00011111,
    0b00001110, // O
    0b00010001,
    0b00010001,
    0b00001110,
    0b00011111, // P
    0b00010100,
    0b00010100,
    0b00001000,
    0b00001110, // Q
    0b00010001,
    0b00010010,
    0b00001101,
    0b00011111, // R
    0b00010100,
    0b00010100,
    0b00001011,
    0b00001001, // S
    0b00010101,
    0b00010101,
    0b00010010,
    0b00010000, // T
    0b00011111,
    0b00010000,
    0b11111111,
    0b00011111, // U
    0b00000001,
    0b00000001,
    0b00011111,
    0b00011100, // V
    0b00000011,
    0b00011100,
    0b00000000,
    0b00011100, // W *
    0b00000011,
    0b00001100,
    0b00000011,
    0b00011011, // X
    0b00000100,
    0b00011011,
    0b00000000,
    0b00011000, // Y
    0b00000111,
    0b00011000,
    0b00000000,
    0b00010011, // Z
    0b00010101,
    0b00010101,
    0b00011001,
    0b00011111, // [
    0b00010001,
    0b00000000,
    0b00000000,
    0b00011000, // \
    0b00000100,
    0b00000011,
    0b00000000,
    0b00000000, // ]
    0b00000000,
    0b00010001,
    0b00011111,
    0b00001000, // ^
    0b00010000,
    0b00001000,
    0b00000000,
    0b00000001, // _
    0b00000001,
    0b00000001,
    0b00000000,
    0b00000000, // `
    0b00010000,
    0b00001000,
    0b00000000
};

byte pwm,row=1,A,B,C;
signed char cursor=0;
unsigned int tick=0;
byte update=1, Minute=0, Hour=10;

void DelayMs(byte cnt) {
	byte i;
	do {
		i = 4;
		do {
			CLRWDT();
			DelayUs(250);
		} while(--i);
	} while(--cnt);
}

void FadeIn(void) {
	byte i;
	for(i=0; i<19; i++) {
		if(Disp[i]<223) Disp[i]+=32;
	}
}

void FadeOut(void) {
	byte i;
	for(i=0; i<19; i++) {
		if(Disp[i]>=32) Disp[i]-=32;
	}
}

// Append column to data buffer at cursor
void Array(byte data, signed y, byte l) {
    byte a;
    if(cursor<0) { cursor++; return; }  // data out of screen
    if(cursor>=19) return;              // data out of screen
    Disp[cursor] = l<<5;                // Set intensity level
    if(y==0) Disp[cursor] |= data;
    else if(y>0) Disp[cursor] |= (data>>y);
    else { y = -y; Disp[cursor] |= (data<<y); }
    cursor++;
}

void Put(byte n,signed char y, byte l) {
	byte i,c;
    unsigned int p;
//    n-=0x20;
	for(i=0; i<4; i++) {
        p=(n-0x20)*4+i;
        c = Font[p];
        if(c==0xFF) break;
        Array(c,y,l);
	}
    if      (n=='M') Array(0b00011111,y,l); // M
    else if (n=='W') Array(0b00011100,y,l); // W
    Array(0b00000000,y,l);
}

void Print (const char *Text, signed char x, signed char y,byte l) {
    cursor = x;
	while(*Text) Put(*Text++,y,l);
}
/*
void Time(void) {
	byte Data,D1=0,D2=0;
	Data=Hour;
	while (Data>=10) { D2++; Data-=10; }
	while (Data>=1)	 { D1++; Data-=1;  }
	cursor=1; if(D2) Put(D2+0x30); else Put(' ');
	Put(D1+0x30); Put(':');
	Data=Minute; D1=0; D2=0;
	while (Data>=10) { D2++; Data-=10; }
	while (Data>=1)	 { D1++; Data-=1;  }
	Put(D2+0x30);
	Put(D1+0x30);
}
*/
/*---------------------------- INTERRUPTS ----------------------------------
	Handles TMR0 interrupt
---------------------------------------------------------------------------*/
void interrupt Interrupts (void) {
	row=row<<1; if(row>=32) row = 1;
	A=B=C=0;
	if((Disp[0]>>5)>pwm)  if(Disp[0]&row)  A+=32;
	if((Disp[1]>>5)>pwm)  if(Disp[1]&row)  A+=128;
	if((Disp[2]>>5)>pwm)  if(Disp[2]&row)  A+=64;
	if((Disp[3]>>5)>pwm)  if(Disp[3]&row)  C+=1;
	if((Disp[4]>>5)>pwm)  if(Disp[4]&row)  C+=2;
	if((Disp[5]>>5)>pwm)  if(Disp[5]&row)  C+=4;
	if((Disp[6]>>5)>pwm)  if(Disp[6]&row)  C+=8;
	if((Disp[7]>>5)>pwm)  if(Disp[7]&row)  C+=16;
	if((Disp[8]>>5)>pwm)  if(Disp[8]&row)  C+=32;
	if((Disp[9]>>5)>pwm)  if(Disp[9]&row)  C+=64;
	if((Disp[10]>>5)>pwm) if(Disp[10]&row) C+=128;
	if((Disp[11]>>5)>pwm) if(Disp[11]&row) B+=1;
	if((Disp[12]>>5)>pwm) if(Disp[12]&row) B+=2;
	if((Disp[13]>>5)>pwm) if(Disp[13]&row) B+=4;
	if((Disp[14]>>5)>pwm) if(Disp[14]&row) B+=8;
	if((Disp[15]>>5)>pwm) if(Disp[15]&row) B+=16;
	if((Disp[16]>>5)>pwm) if(Disp[16]&row) B+=32;
	if((Disp[17]>>5)>pwm) if(Disp[17]&row) B+=64;
	if((Disp[18]>>5)>pwm) if(Disp[18]&row) B+=128;
	switch(row) {
		case 1:  A+=0b00011110; break;
		case 2:  A+=0b00011101; break;
		case 4:  A+=0b00011011; break;
		case 8:  A+=0b00010111; break;
		case 16: A+=0b00001111;
				pwm++;
				if(pwm>=8) {	// 61Hz
					pwm=0;
/*					tick++;
					if(tick>=3662) {
						tick=0;
						Minute++;
						update = 1;
						if(Minute>=60) {
							Minute = 0;
							Hour++;
							if(Hour>12) Hour=1;
						}
					}*/
				}
				break;
	}
    PORTA = A;
	PORTB = B;
	PORTC = C;
	T0IF = 0;				// Reset TMR0 interrupt flag
}

/*-------------------------- MAIN -------------------------------
	- Configure PIC
-----------------------------------------------------------------*/
void main (void) {
	byte i,Mode = 0;
    signed char count = 0;
	TRISA =  0b00000000;
	PORTA =  0b00011011;
	TRISB =  0b00000000;
	PORTB =  1;
	TRISC =  0b00000000;
	PORTC =  0;
	OPTION = 0b11010000;
	OSCCON = 0b01110000;
	INTCON = 0b10100000;
    Print("LEDS",0,0,7);
	for(;;) {
		switch(Mode) {
			case 0: // DELAY
                    DelayMs(250);
					if(count>=8) { Mode++; count = -5; }
            break;
            case 1: // PRINT DROP
                    DelayMs(250); 
                    Print("DROP",0,count,7);
                    if(count==0) Mode++;
            break;
            case 2: // DELAY
                    DelayMs(250);
					if(count>=8) { Mode++; count = 0; }
            break;
			case 3: // DROP TEXT
                    DelayMs(250);
                    Print("DROP",0,count,7);
					if(count>=5) { Mode++; count = 0; }
            break;
			case 4: // PRINT FADE
                    DelayMs(250);
                    Print("FADE",0,0,count);
					if(count>=7) { Mode++; count = 0; }
            break;
			case 5: // FADE OUT
                    DelayMs(250);
                    Print("FADE",0,0,7-count);
					if(count>=7) { Mode++; count = 0; }
            break;
			case 6: // PRINT FADE
                    DelayMs(250);
                    Print("FADE",0,0,count);
					if(count>=7) { Mode++; count = 0; }
            break;
			case 7: // FADE OUT
                    DelayMs(250);
                    Print("FADE",0,0,7-count);
					if(count>=7) { Mode++; count = 0; }
            break;
            case 8: for(i=0; i<=90; i++) {
                        Print("    GABOTRONICS.COM ",-i,0,7);
                        DelayMs(250);
                    }
            break;
		}
		count++;
		CLRWDT();
	}
}
