/*****************************************************************************

MultiKitB: AVR Oscilloscope and Development Kit

Gabotronics C.A.
February 2009

Copyright 2009 Gabriel Anzziani

This program is distributed under the terms of the GNU General Public License 

www.gabotronics.com
email me at: gabriel@gabotronics.com

Simple application to demonstrate the use of the rotary encoders

*****************************************************************************/

#include <avr/io.h>
#include <avr/pgmspace.h>
#include <avr/sleep.h>
#include "mygccdef.h"
#include "multikit.h"
#include "sed1335.h"

void SKTCH(void) {
    byte x=0,y=0,mode=255, thick=1;

    lcd_init(TEXT); // Text and Graphics mode

    // Encoders
    ROT1 = 64; MAX1 = 127;
    ROT2 = 64; MAX2 = 127;

    for(;;) {
        
        if(x!=ROT1 || y!=ROT2) {
            x=ROT1; y=ROT2;
            // draw point
            pixel(x,y,mode);
            if(thick) {
                pixel(x-1,y,mode);
                pixel(x+1,y,mode);
                pixel(x,y+1,mode);
                pixel(x,y-1,mode);
            }
        }
        setbit(SMCR,SE);                // Enable Sleep
        sleep_cpu();

        switch(key) {
            case K1: lcd_clear_graphics(); break;
            case K2: mode = 0; break;       // white
            case K3: mode = 128; break;     // gray
            case K4: mode = 255; break;     // black
            case K5: thick = 1; break;
            case K6: thick = 0; break;
            case K7: return;
        }
        while(key) {
            setbit(SMCR,SE);                // Enable Sleep
            sleep_cpu();
        }
    }
}
