/*****************************************************************************

MultiKitB: AVR Oscilloscope and Development Kit

Gabotronics C.A.
February 2009

Copyright 2009 Gabriel Anzziani

This program is distributed under the terms of the GNU General Public License 

www.gabotronics.com
email me at: gabriel@gabotronics.com

Simple application to demonstrate the use of the buzzer and to observe the
how the toggle switches and different combinations are multiplexed into a
single analog input.

    Musical Notes:

    C:  261.64  --> 3.8220mS
    D:  293.68  --> 3.4051mS
    E:  329.64  --> 3.0336mS
    F:  349.24  --> 2.8633mS
    G:  392.00  --> 2.5510mS    
    
*****************************************************************************/

#include <avr/io.h>
#include <avr/pgmspace.h>
#include <avr/interrupt.h>
#include <avr/sleep.h>
#include "mygccdef.h"
#include "multikit.h"
#include "sed1335.h"

byte F1, F2;
volatile byte Freq1, Freq2;

byte Freqs1[17] PROGMEM = { 0, 96, 85, 96, 76, 96, 85, 72, 96, 85, 76, 64, 96, 85, 76, 72, 58 };
byte Freqs2[17] PROGMEM = { 0,  0,  0, 85,  0, 76, 76,  0, 72, 72, 72,  0, 64, 64, 64, 64 };

void PIANO(void) {
    // Fast CPU
    CLKPR = 0x80;       // Change clock prescaler
    CLKPR = 0x02;       // Clock prescaler = 4
    SMCR = 0x60;        // Sleep mode = idle, sleep disabled
    lcd_init(TEXT);
    lcd_puts(PSTR("PIANO"));
    clrbit(PRR,PRTIM2); // Power up Timer 2
    TCCR2A = 2;     // Clear Timer on Compare mode
    TCCR2B = 1;     // clk/1
    TIMSK2 = 2;     // enable compare match A interrupt
    OCR2A = 100;    // --> Timer 2 period = 20uS
    while (key!=K7) {
        setbit(SMCR,SE);                // Enable Sleep
        sleep_cpu();
        Freq1 = (byte)pgm_read_byte_near(Freqs1+key);
//        Freq2 = (byte)pgm_read_byte_near(Freqs2+key);
    }
    TIMSK2 = 0;
}

ISR (TIMER2_COMPA_vect) {
    F1++; if(Freq1 && F1>Freq1) { setbit(PIND, BUZZER); F1=0; }
//    F2++; if(Freq2 && F2>Freq2) { setbit(PIND, BUZZER); F2=0; }
}

