;MultiKitB: AVR Oscilloscope and Development Kit
;
;Gabotronics C.A.
;February 2009
;
;Copyright 2009 Gabriel Anzziani
;
;This program is distributed under the terms of the GNU General Public License 
;
;www.gabotronics.com
;email me at: gabriel@gabotronics.com

#include <avr/io.h>

;----------------------------------------------------------------------------;
; 1:7 Fixed Point Multiplication
.global fmuls_8
.func fmuls_8
fmuls_8:
    push r23
    mov r23, r24
    fmuls R22, R23
    mov r24, r1
    pop r23
	clr	r1
	ret
.endfunc

; 8:8 Fixed Point Multiplication
.global fixmult
.func fixmult
fixmult:
    push r20
    push r21
    movw  r20,r24
    
    muls	r23, r21	; (signed)ah * (signed)bh
    mov		r31, r0		;
    mul		r22, r20	; al * bl
    mov 	r30, r1		;
    ;mov	r16, r0
    mulsu	r23, r20	; (signed)ah * bl
    add		r30, r0     ;
    adc		r31, r1     ;
    mulsu	r21, r22	; (signed)bh * al
    add		r30, r0     ;
    adc		r31, r1     ;
	
    movw    r24,r30
    pop r21
    pop r20
    clr r1
    ret
.endfunc


