/*****************************************************************************

MultiKitB: AVR Oscilloscope and Development Kit

Gabotronics C.A.
February 2009

Copyright 2009 Gabriel Anzziani

This program is distributed under the terms of the GNU General Public License 

www.gabotronics.com
email me at: gabriel@gabotronics.com

3D DEMO

The data type used is 1:7 signed fractionals
(see http://en.wikipedia.org/wiki/Q_(number_format) )
The fractional format has a range of [-1, 1)
All points in the 3D demo will be in this range, and then scaled to the LCD's
screen at the moment of plotting.
The AVR microcontroller can handle directly fractional format numbers.
(see http://www.atmel.com/dyn/resources/prod_documents/doc1631.pdf )
Since the C language doesn't support fractionals, I use signed chars instead
which have a direct relation:

signed char		fractional
-128			-1
-127			-0.9921875
-64				-0.5
-32				-0.25
0				 0
32				 0.25
64				 0.5
127				 0.9921875

Adding and substacting can be done directly in C, but for multiplication, I
have to use the AVR's instruction FMULS

In this demo, a pseudo sphere is generated using sines and cosines (which are
also in the fractional format). Each point is multiplied by the rotation
matrix. The rotation angle is determined by the output of the accelerometer.
For more information on the rotation matrix, see:
http://www.cs.unc.edu/~geom/HOFF/projects/comp236_ta/rotations/rotations.pdf

*****************************************************************************/

#include <avr/io.h>
#include <util/delay_basic.h>
#include <avr/eeprom.h>
#include <avr/sleep.h>
#include "mygccdef.h"
#include "sed1335.h"
#include "multikit.h"

void THREED(void) {
    byte i,j,l;
    byte alfa=0,beta=0,gama=0,oldalfa=1,oldbeta=1,oldgama=1;
    signed char p[3];
	signed char ROTX[3][3]={ {127,  0,  0},
							 {  0,  0,  0},
						     {  0,  0,  0} };

	signed char ROTY[3][3]={ {  0,  0,  0},
							 {  0,127,  0},
							 {  0,  0,  0} };

//	signed char ROTZ[3][3]={ {  0,  0,  0},
//							 {  0,  0,  0},
//							 {  0,  0,127} };
//	signed char ROTYZ[3][3];
	signed char ROTXYZ[3][3];
    signed char OUT[2];
    byte delta;

    lcd_init(GRAPHICS);
    // Encoders:
    ROT1 = 0; MAX1 = 255;
    ROT2 = 0; MAX2 = 255;

    for(;;) {
        alfa = ROT1;
        beta = ROT2;
        if((oldalfa!=alfa) || (oldbeta!=beta) || (oldgama!=gama)) {
            // Calculate Rotation Matrix
            // X Matrix
        	ROTX[1][1]=ROTX[2][2]= Cos(alfa);
    	    ROTX[1][2]=-Sin(alfa);
            ROTX[2][1]=Sin(alfa);
            // Y Matrix
    	    ROTY[0][0]=ROTY[2][2]=Cos(beta);
    	    ROTY[0][2]=Sin(beta);
            ROTY[2][0]=-Sin(beta);
            // Z Matrix
/*    	    ROTZ[0][0]=ROTZ[1][1]=Cos(gama);
    	    ROTZ[0][1]=-Sin(gama);
            ROTZ[1][0]=Sin(gama);
            // YZ = Y*Z
            for(gi=0; gi<3; gi++) {
                for(gj=0; gj<3; gj++) {
                    ROTYZ[gi][gj]= fmuls_8(ROTY[0][gj],ROTZ[gi][0])+
                                   fmuls_8(ROTY[1][gj],ROTZ[gi][1])+
                                   fmuls_8(ROTY[2][gj],ROTZ[gi][2]);
                }
            }
            // XYZ = X*YZ
            for(gi=0; gi<3; gi++) {
                for(gj=0; gj<3; gj++) {
                    ROTXYZ[gi][gj]= fmuls_8(ROTX[0][gj],ROTYZ[gi][0])+
                                    fmuls_8(ROTX[1][gj],ROTYZ[gi][1])+
                                    fmuls_8(ROTX[2][gj],ROTYZ[gi][2]);
                }
            }*/

            for(i=0; i<3; i++) {
                for(j=0; j<3; j++) {
                    ROTXYZ[i][j]= fmuls_8(ROTX[0][j],ROTY[i][0])+
                                  fmuls_8(ROTX[1][j],ROTY[i][1])+
                                  fmuls_8(ROTX[2][j],ROTY[i][2]);
                }
            }
        }

//      Pseudo sphere
  	    for(l=8; l<=120; l+=8) {
            j=0;
            do {
                p[0]= ((int)(Cos(j)*Sin(l))>>9);  // X
                p[1]= ((int)(Sin(j)*Sin(l))>>9);  // Y
			    p[2]= (signed char)((signed char)(l-64)>>1);  // Z

                // PLOT 3D PIXEL
                // Multiply Rotation Matrix by 3D point
                for(i=0; i<2; i++) {
                    OUT[i]= fmuls_8(p[0],ROTXYZ[i][0])+
                            fmuls_8(p[1],ROTXYZ[i][1])+
                            fmuls_8(p[2],ROTXYZ[i][2]);
                }
	            pixel(OUT[0]+64,OUT[1]+64,255);

                j+=8;
            } while (j);
        }
        setbit(SMCR,SE);                // Enable Sleep
        sleep_cpu();
        if(key==K7) return;
        lcd_clear_graphics();
    }
}

