/****************************************************************************

MultiKit: AVR Oscilloscope and Development Kit

Gabotronics C.A.
February 2009

Copyright 2009 Gabriel Anzziani

This program is distributed under the terms of the GNU General Public License 

www.gabotronics.com
email me at: gabriel@gabotronics.com

*****************************************************************************/

#define NOKEY   0
#define K1      1
#define K2      2
#define K12     3
#define K3      4
#define K13     5
#define K23     6
#define K4      7
#define K14     8
#define K24     9
#define K34     10
#define K5      11
#define K15     12
#define K25     13
#define K35     14
#define K45     15
#define K6      16
#define K7      17      // (ON Button)

// PORT DEFINITIONS
#define ONBUTTON    1   // PORTA
#define POWERUP     2   // PORTA
#define LED         3   // PORTA
#define ADS931POW   4   // PORTA
#define ADS931NOUT  3   // PORTB
#define BUZZER      6   // PORTD


byte random();

// Multikit Hardware Control
void KEYS(void);            // Keys input
void POT(void);             // Potentiometer
void ADXL(void);            // Acceleromenter
void LEDS(byte n);          // LEDS output
void Negative(byte set);    // Negative voltage

extern signed char sint[128];
signed char Sin(byte angle);
signed char Cos(byte angle);

extern volatile byte key,oldkey,ROT1,ROT2,MAX1,MAX2;

// MSO Encoder definitions
#define GAINRATE    1
#define CURSORH     2
#define CURSORV     3
#define DISPLAY     4
#define TRIGGER     5

// Status bits
#define Status      GPIOR0  // Global status in GPIOR0 register for fast access
#define autotrg     0       // autotrigger set
#define single      1       // Single trigger
#define trigger     2       // oscilloscope triggered
#define stop        3       // Scope stopped
#define digitrig    4       // Trigger on digital inputs
#define trigdir     5       // trigger falling or rising
#define fft         6       // FFT
#define update      7       // Update settings and screen

// Option bits
#define Option  GPIOR1      // Oscilloscope Options
#define hideset     0       // Hide scope settings ( time/div volts/div)
#define nowindow    1       // Don't apply Hamming window prior to FFT
#define cursorh     2       // X Cursor on
#define cursorv     3       // Y Cursor on
#define persistent  4       // persistent display
#define line        5       // continous drawing
#define digital     6       // Display digital data
#define math        7       // Math


