; MultiKitB: AVR Oscilloscope and Development Kit
;
; Gabotronics C.A.
; January 2010
;
; Copyright 2010 Gabriel Anzziani
;
; This program is distributed under the terms of the GNU General Public License 
;
; www.gabotronics.com
; email me at: gabriel@gabotronics.com

#include <avr/io.h>

;----------------------------------------------------------------------------;
; 1:7 Fixed Point Multiplication
.global fmuls_8
.func fmuls_8
fmuls_8:                ; input: r24, r22
    mov   r23, r24
    fmuls r22, r23
    mov r24, r1         ; return value in r24
	clr	r1
	ret
.endfunc

; trigger on digital input - rising edge
;----------------------------------------------------------------------------;
;
.global digitrigup
.func digitrigup
digitrigup:	; input r24: triggervalue
	sbic	_SFR_IO_ADDR(GPIOR0),7	; 2 cycle ; Status update?
	rjmp	digicanceltrigd
    sbic    _SFR_IO_ADDR(PINB),5	; 2 cycle ; check if line is low
	rjmp	digitrigup

digitrigcheck2d:
	sbic	_SFR_IO_ADDR(GPIOR0),7	; 2 cycle ; Status update?
	rjmp	digicanceltrigd
    sbis    _SFR_IO_ADDR(PINB),5    ; 2 cycle ; check if line is hi
	rjmp	digitrigcheck2d

digitriggeredd:
	sbi		_SFR_IO_ADDR(GPIOR0), 2  ; Set trigger

digicanceltrigd:
    ret
.endfunc

; falling edge trigger detect
;----------------------------------------------------------------------------;
;
;                 data1  ___.
;                            \
;  triggervalue - - - - - - - \
;                              \.___ data2
;
.global trigdown
.func trigdown
trigdown:	; input r24: triggervalue

	in		r0,_SFR_IO_ADDR(PINC)	; 1 cycle ; data1= Read portC input
	cp		r24,r0		            ; 1 cycle ; compare triggervalue with data1
	brlo    trigcheck2d	            ; 1 cycle  ; triggervalue < data1 ?
	sbis	_SFR_IO_ADDR(GPIOR0),7	; 1 cycle ; Status update?
	rjmp	trigdown	            ; 2 cycles
						            ; 6 cycles
	rjmp	canceltrigd

trigcheck2d:
	in		r0,0x06	                ; 1 cycle ; data2= Read portB input
	cp		r0,r24		            ; 1 cycle ; compare triggervalue with data2
	brlo    triggeredd	            ; 1 cycle  ; data2 < triggervalue ?
	sbis	_SFR_IO_ADDR(GPIOR0),7	; 1 cycle ; Status update?
	rjmp	trigcheck2d	            ; 2 cycles
						            ; 6 cycles	
	rjmp	canceltrigd

triggeredd:
	sbi		_SFR_IO_ADDR(GPIOR0), 2  ; Set trigger

canceltrigd:
    ret
.endfunc


; rising edge trigger detect
;----------------------------------------------------------------------------;
;
;                              .___ data2 
;                              /
;  triggervalue - - - - - - - /
;                  data1 ___./   
;
.global trigup
.func trigup
trigup:     ; input r24: triggervalue

	in		r0,_SFR_IO_ADDR(PINC)	; 1 cycle ; data1= Read portC input
	cp		r0,r24		            ; 1 cycle ; compare triggervalue with data1
	brlo    trigcheck2u	            ; 1 cycle  ; triggervalue < data1 ?
	sbis	_SFR_IO_ADDR(GPIOR0),7	; 1 cycle ; Status update?
	rjmp	trigup	                ; 2 cycles
						            ; 6 cycles
	rjmp	canceltrigu

trigcheck2u:
	in		r0,0x06	                ; 1 cycle ; data2= Read portB input
	cp		r24,r0		            ; 1 cycle ; compare triggervalue with data2
	brlo    triggeredu	            ; 1 cycle  ; data2 < triggervalue ?
	sbis	_SFR_IO_ADDR(GPIOR0),7	; 1 cycle ; Status update?
	rjmp	trigcheck2u	            ; 2 cycles
						            ; 6 cycles	
	rjmp	canceltrigu

triggeredu:
	sbi		_SFR_IO_ADDR(GPIOR0), 2  ; Set trigger

canceltrigu:
    ret
.endfunc


;----------------------------------------------------------------------------;
; 5uS   / div  ->  312.5nS / pixel ->  3.2 MS / s
.global acquire1
.func acquire1   ; input: r22:r23, r24:r25
acquire1:
    push r28    ; Save YL
    push r29    ; Save YH
    push r30    ; Save ZL
    push r31    ; Save ZH
    movw YL, r24
    movw ZL, r22

    ; ADC is delayed 5 samples, so read 5 digital inputs first to be in sync
    in   R22,0x03
    ST   Z+,R22
    lpm				; 3 cycle delay
    in   R22,0x03
    ST   Z+,R22
    lpm
    in   R22,0x03
    ST   Z+,R22
    lpm
    in   R22,0x03
    ST   Z+,R22
    lpm
    in   R22,0x03
    ST   Z+,R22
	; cycles
    in   R24,0x06   ; 1 cycle
    ST   Y+,R24		; 2 cycles
    in   R22,0x03	; 1 cycle
    ST   Z+,R22		; 2 cycles
					; 6 cycles total for one set of samples (analog+digital)
					; 19.2Mhz / 6 cycles = 3.2MHz
    in   R24,0x06   ; 2 sample
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 3 sample
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 4 sample
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 5 sample
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 6 sample
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 7 sample
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 8 sample
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 1
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 2
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 3
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 4
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 5
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 6
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 7
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 8
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 1
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 2
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 3
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 4
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 5
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 6
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 7
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 8
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 1
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 2
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 3
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 4
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 5
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 6
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 7
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 8
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 1
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 2
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 3
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 4
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 5
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 6
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 7
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 8
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 1
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 2
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 3
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 4
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 5
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 6
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 7
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 8
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 1
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 2
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 3
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 4
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 5
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 6
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 7
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 8
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 1
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 2
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 3
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 4
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 5
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 6
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 7
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 8
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 1
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 2
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 3
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 4
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 5
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 6
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 7
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 8
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 1
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 2
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 3
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 4
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 5
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 6
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 7
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 8
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 1
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 2
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 3
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 4
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 5
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 6
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 7
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 8
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 1
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 2
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 3
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 4
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 5
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 6
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 7
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 8
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 1
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 2
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 3
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 4
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 5
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 6
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 7
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 8
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 1
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 2
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 3
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 4
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 5
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 6
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 7
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 8
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 1
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 2
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 3
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 4
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 5
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 6
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 7
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 8
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 1
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 2
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
    in   R24,0x06   ; 3
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22

    ; Last 5 analog inputs
    in   R24,0x06   ; 4
    ST   Y+,R24
    lpm
    in   R24,0x06   ; 5
    ST   Y+,R24
    lpm
    in   R24,0x06   ; 6
    ST   Y+,R24
    lpm
    in   R24,0x06   ; 7
    ST   Y+,R24
    lpm
    in   R24,0x06   ; 8
    ST   Y+,R24

    pop r31
    pop r30
    pop r29
    pop r28
	ret
.endfunc

;----------------------------------------------------------------------------;
; 10uS  / div  ->  625nS   / pixel ->  1.6 MS / s
.global acquire2
.func acquire2
acquire2:       ; input: r22:r23, r24:r25
    push r28    ; Save YL
    push r29    ; Save YH
    push r30    ; Save ZL
    push r31    ; Save ZH
    movw YL, r24
    movw ZL, r22
    ldi r25, 128

    ; ADC is delayed 5 samples, so read 5 digital inputs first to be in sync
    in   R22,0x03
    ST   Z+,R22
    lpm				; 3 cycle delay
    lpm				; 3 cycle delay
    lpm				; 3 cycle delay
    in   R22,0x03
    ST   Z+,R22
    lpm
    lpm
    lpm
    in   R22,0x03
    ST   Z+,R22
    lpm
    lpm
    lpm
    in   R22,0x03
    ST   Z+,R22
    lpm
    lpm
    lpm
    in   R22,0x03
    ST   Z+,R22
; remaining samples:
more:                   ; cycles:
    in   R24,0x06       ; 1
    ST   Y+,R24         ; 2
    in   R22,0x03       ; 1
    ST   Z+,R22         ; 2
    lpm                 ; 3
    dec  r25            ; 1
    brne more           ; 2
                        ; = 12 cycles total for one set of samples (analog+digital)
						; 19.2Mhz / 12 cycles = 1.6MHz
    pop r31
    pop r30
    pop r29
    pop r28
	ret
.endfunc

;----------------------------------------------------------------------------;
.global acquire3
.func acquire3
acquire3:       ; input: r22:r23, r24:r25
    push r28    ; Save YL
    push r29    ; Save YH
    push r30    ; Save ZL
    push r31    ; Save ZH
    movw YL, r24
    movw ZL, r22
    ldi r25, 136    ; Acquire 135 samples (first 8 are out of sync)

more3:
    in   R24,0x06
    ST   Y+,R24
    in   R22,0x03
    ST   Z+,R22
wait:
    SBIS    0x15,2      ;wait for timer
    RJMP    wait
    SBI     0x15,2
    dec  r25
    brne more3

    pop r31
    pop r30
    pop r29
    pop r28
	ret
.endfunc
