/***********************************************************************

MultiKit: AVR Oscilloscope and Development Kit

Gabotronics C.A.
February 2009

Copyright 2009 Gabriel Anzziani

This program is distributed under the terms of the GNU General Public License 

www.gabotronics.com
email me at: gabriel@gabotronics.com

Gabriel Anzziani - gabriel@gabotronics.com
based on library from: Knut Baardsen @ Baardsen Software, Norway

*****************************************************************************/

/***********************************************************************
Port, PINS and LCD defines 
***********************************************************************/

#include <avr/pgmspace.h>

// Data port
#define LCDDATAPIN  PINC
#define LCDDATADDR  DDRC
#define LCDDATAPORT PORTC
// Control port
#define LCDCTLPIN   PINB
#define LCDCTLDDR   DDRB
#define LCDCTLPORT  PORTB
// Control pins
#define RD          1
#define WR          2
#define A0          4
// LCD display info, specific to the display used:
// DMF5008N: 128x128 pixels, 8kB RAM
#define LCD_X_SIZE  128
#define LCD_Y_SIZE  128
#define DISPMEM     8192
#define LCD_XTAL    6000000
#define TEXT        0
#define GRAPHICS    0x0C

#define IV          1       // 0: Screen top-line correction
                            // 1: No screen top-line correction
#define WS          1       // 0: Single-panel drive 1: Dual-panel drive
#define M2          0       // 0: 8-pixel character height
                            // 1: 16-pixel character height
#define M1          1       // 0: CG RAM1 and CG RAM2 address spaces are not
                            // contiguous, the CG RAM1 address space is
                            // treated as character generator RAM, and the
                            // CG RAM2 address space is treated as character
                            // generator ROM.
                            // 1: The CG RAM1 and CG RAM2 address spaces are
                            // contiguout and are both treated as character
                            // generator RAM.
#define M0          0       // 0: Internal CG ROM 1: External CG ROM
#define WF          1       // 0: 16-line AC drive 1: two-frame AC drive
#define FX          5       // Horizontal character size - 1
#define FY          7       // Vertical character size - 1
#define CR          (LCD_X_SIZE/(FX+1)-1)
                            // Address range covered by one display line
#define TCR         ((LCD_XTAL / 70 / LCD_Y_SIZE) / 9)
#define LF          (LCD_Y_SIZE - 1)
#define APL         (CR+1)
#define APH         0
#define SL1         (LCD_Y_SIZE>>WS)
#define SL2         (LCD_Y_SIZE>>WS)
#define SAD1L       (lobyte((unsigned int)LCD_Y_SIZE*APL)) // Screen layer 1 pointer
#define SAD1H       (hibyte((unsigned int)LCD_Y_SIZE*APL))
#define SAD2L       0x00                                // Screen layer 2 pointer (Graphics)
#define SAD2H       0x00
#define SAD3L       (lobyte(3*(unsigned int)SL1*APL))   // Screen layer 3 pointer
#define SAD3H       (hibyte(3*(unsigned int)SL1*APL))
#define SAD4L       (lobyte((unsigned int)SL1*APL))     // Screen layer 4 pointer (Graphics)
#define SAD4H       (hibyte((unsigned int)SL1*APL))
#define SAGL        0x00    // CGRAM Address
#define SAGH        0x0A

// LCD Commands: COMMAND    // (# of bytes after command)
#define SYSTEM_SET  0x40    // (8) Initialize Device
#define SLEEP_IN    0x53    // (0) Enter stand-by mode
#define DISP_ON     0x59    // (1) Enable display flashing
#define DISP_OFF    0x58    // (1) Disable display flashing
#define SCROLL      0x44    // (10) Set display start address and display regions
#define CSRFORM     0x5D    // (2) Set cursor type
#define CGRAM_ADR   0x5C    // (2) Set start address of character generator RAM
#define CSR_RIGHT   0x4C    // (0) Set direction of cursor movement: right
#define CSR_LEFT    0x4D    // (0) Set direction of cursor movement: left
#define CSR_UP      0x4E    // (0) Set direction of cursor movement: up
#define CSR_DOWN    0x4F    // (0) Set direction of cursor movement: down
#define HDOT_SCR    0x5A    // (1) Set horizontal scroll position
#define OVLAY       0x5B    // (1) Set display overlay format
#define CSRW        0x46    // (2) Set cursor address
#define CSRR        0x47    // (2) Read cursor address
#define MWRITE      0x42    // Write to display memory
#define MREAD       0x43    // Read from display memory

/***********************************************************************
Prototypes
***********************************************************************/
// General LCD functions
unsigned char lcd_read_data(void);
void lcd_write_data(unsigned char data);
void lcd_write_command(unsigned char command);
void lcd_init(void);
void lcd_delay(void);
// Text functions
void lcd_clear_text(void);
void lcd_goto(unsigned char row, unsigned char col);
//void lcd_write_string(char *ptr);
void lcd_puts(const PROGMEM char*);
void lcd_show_cursor(unsigned char rate);
void PrintN(unsigned char Data);

