/***********************************************************************

MultiKit: AVR Oscilloscope and Development Kit

Gabotronics C.A.
February 2009

Copyright 2009 Gabriel Anzziani

This program is distributed under the terms of the GNU General Public License 

www.gabotronics.com
email me at: gabriel@gabotronics.com

*****************************************************************************/

typedef unsigned char byte;

#define setbit(port, bit) ((port) |= (byte)_BV(bit))
#define setbits(port, mask) ((port) |= (byte)(mask))
#define clrbit(port, bit) ((port) &= (byte)~_BV(bit))
#define clrbits(port, mask) ((port) &= (byte)~(mask))
#define testbit(port, bit) (byte)(((byte)port & (byte)_BV(bit)))
#define togglebit(port, bit) (port ^= (byte)_BV(bit))
#define	hibyte(x) (byte)(x>>8)
#define	lobyte(x) (byte)(x&0x00FF)


void delay_ms(byte n);
static __inline__ void NOP (void) { __asm__ volatile ( "nop    " "\n\t" ); }

// ### ROL ### Logical Rotate Left Of Register Through Carry 
#define ASM_ROL(reg) asm volatile ("rol %0" : "=r" (reg) : "0" (reg)) 

// ### ROR ### Logical Rotate Right Of Register Through Carry 
#define ASM_ROR(reg) asm volatile ("ror %0" : "=r" (reg) : "0" (reg)) 

// Swap two bytes
#define SWAP(x,y) do { (x)=(x)^(y); (y)=(x)^(y); (x)=(x)^(y); } while(0)

// 8:8 Fixed Point Math
typedef signed int fixed;
#define int2fix(a)   (((int)(a))<<8)            //Convert char to fix
#define fix2int(a)   ((signed char)((a)>>8))    //Convert fix to char
#define float2fix(a) ((int)((a)*256.0))         //Convert float to fix
#define fix2float(a) ((float)(a)/256.0)         //Convert fix to float
#define multfix(a,b) ((int)((((long)(a))*((long)(b)))>>8)) //multiply two fixe
#define divfix(a,b)  ((int)((((long)(a))<<8)/((long)(b)))) //divide two fixed

/*// 16:16 Fixed Point Math
//Type conversions
typedef signed long fixed;
#define int2fix(a)   (((long)(a))<<16)            //Convert char to fix. a is a char
#define fix2int(a)   ((int)((a)>>16))    //Convert fix to char. a is an int(in fixed notation)
#define float2fix(a) ((long)((a)*65536.0))         //Convert float to fix. a is a float
#define fix2float(a) ((float)(a)/65536.0)         //Convert fix to float. a is an int(in fixed notation) 
#define multfix(a,b) ( (long) ( ( ((long)(a)) * ((long)(b)) )>>16)) //multiply two fixed #
#define divfix(a,b)  ((long)((((long)(a))<<16)/((long)(b)))) //divide two fixed #
*/

