/****************************************************************************

XMEGA Oscilloscope and Development Kit

Gabotronics
February 2012

Copyright 2012 Gabriel Anzziani

This program is distributed under the terms of the GNU General Public License

www.gabotronics.com
email me at: gabriel@gabotronics.com

*****************************************************************************/

#include <avr/pgmspace.h>
// Xminilab
const unsigned char LOGO[] PROGMEM = {
// Gabotronics
    '\x00','\x00','\x30','\xff','\xff','\x03','\x07','\x07', // 0x0008
    '\x02','\x27','\x67','\xe7','\xe7','\x04','\xc6','\x84', // 0x0010
    '\x00','\x00','\x02','\x01','\x03','\x07','\x07','\x04', // 0x0018
    '\xe7','\xc7','\x87','\x07','\x07','\x02','\x06','\x04', // 0x0020
    '\x00','\x00','\x64','\x03','\x07','\x0f','\x00','\x00', // 0x0028
    '\x07','\x03','\x07','\x0f','\x00','\x00','\x08','\x03', // 0x0030
    '\x07','\x0f','\x00','\x00','\x48','\x7e','\xff','\x81', // 0x0038
    '\x91','\x91','\x02','\xf1','\x60','\x00','\x60','\xf4', // 0x0040
    '\x94','\x94','\x02','\xfc','\xf8','\x00','\xff','\xff', // 0x0048
    '\x02','\x84','\x84','\x02','\xfc','\x78','\x00','\x78', // 0x0050
    '\xfc','\x84','\x84','\x02','\xfc','\x78','\x00','\x04', // 0x0058
    '\x7f','\xff','\x84','\x84','\x02','\x00','\xfc','\xfc', // 0x0060
    '\x02','\x08','\x0c','\x0c','\x02','\x00','\x78','\xfc', // 0x0068
    '\x84','\x84','\x02','\xfc','\x78','\x00','\xf8','\xfc', // 0x0070
    '\x04','\x04','\x02','\xfc','\xf8','\x00','\xfd','\xfd', // 0x0078
    '\x02','\x00','\x78','\xfc','\x84','\x84','\x03','\x00', // 0x0080
    '\x98','\xbc','\xb4','\xf4','\x64','\x00','\xc0','\xc0', // 0x0088
    '\x02','\x00','\x78','\xfc','\x84','\x84','\x03','\x00', // 0x0090
    '\x78','\xfc','\x84','\x84','\x02','\xfc','\x78','\x00', // 0x0098
    '\xf8','\xfc','\x04','\x04','\x02','\xfc','\xf8','\x04', // 0x00a0
    '\x04','\x02','\xfc','\xf8','\x00','\x00','\xa7','\x1c', // 0x00a8
    '\x7e','\xff','\xff','\x02','\xfe','\xfc','\xf8','\xe0', // 0x00b0
    '\x80','\xc0','\xf0','\xf8','\xfc','\xfe','\xff','\x7f', // 0x00b8
    '\x1f','\x06','\x00','\x00','\x11','\x60','\x60','\x02', // 0x00c0
    '\x00','\x00','\x0c','\x60','\x60','\x02','\x00','\x00', // 0x00c8
    '\x02','\xe0','\xe0','\x02','\x00','\x00','\x0b','\xe0', // 0x00d0
    '\xe0','\x02','\x00','\x00','\x3f','\x01','\x83','\xef', // 0x00d8
    '\xff','\xff','\x05','\xef','\x07','\x03','\x00','\x00', // 0x00e0
    '\x07','\xff','\xff','\x02','\x06','\x03','\x03','\x02', // 0x00e8
    '\xff','\xfe','\x06','\x03','\x03','\x02','\xff','\xfe', // 0x00f0
    '\x00','\x00','\x02','\xff','\xff','\x02','\x00','\x00', // 0x00f8
    '\x02','\xff','\xff','\x02','\x06','\x03','\x03','\x03', // 0x0100
    '\xff','\xfe','\x00','\x00','\x02','\xff','\xff','\x02', // 0x0108
    '\x00','\x00','\x02','\xff','\xff','\x02','\x00','\x00', // 0x0110
    '\x02','\x72','\xfb','\xdb','\xcb','\xcb','\x02','\x7f', // 0x0118
    '\xfe','\x80','\x00','\xff','\xff','\x02','\x66','\xc3', // 0x0120
    '\xc3','\x02','\xe7','\x7e','\x3c','\x00','\x00','\x35', // 0x0128
    '\xc0','\xe0','\x78','\x3c','\x3f','\x1f','\x0f','\x07', // 0x0130
    '\x03','\x07','\x1f','\x7f','\xff','\xff','\x02','\xf8', // 0x0138
    '\xc0','\x00','\x00','\x7d','\x01','\x07','\x0f','\x0e', // 0x0140
    '\x00','\x00','\x59',
};

/*// synthetos
    '\x00','\x00','\x3c','\xa4','\x78','\x8e','\xb5','\xae', // 0x0008
    '\x9b','\xb5','\x8f','\xb9','\xaf','\x95','\xbb','\x0d', // 0x0010
    '\x37','\xd9','\x2f','\xf5','\x1b','\xad','\x97','\xb9', // 0x0018
    '\x8f','\xb5','\x9b','\xad','\x97','\xb9','\x8f','\xb5', // 0x0020
    '\x5b','\x2d','\xd7','\x39','\x8f','\xd5','\xdb','\xcd', // 0x0028
    '\xd7','\xd9','\xcf','\xd5','\xdb','\xcd','\xd7','\xd9', // 0x0030
    '\xcf','\xd5','\xdb','\xcd','\xd7','\xd9','\xcf','\xd5', // 0x0038
    '\xdb','\x8d','\x17','\xb9','\xcf','\x35','\xdb','\x6d', // 0x0040
    '\x97','\xf9','\x0f','\xf2','\x5e','\xa4','\x78','\x00', // 0x0048
    '\x00','\x3c','\xaa','\x9f','\x9f','\x02','\x99','\x99', // 0x0050
    '\x05','\xb9','\xf9','\xf7','\x1f','\x9c','\x19','\xfa', // 0x0058
    '\xf9','\x1b','\x1c','\x5f','\x8f','\xff','\xff','\x02', // 0x0060
    '\x01','\x45','\x2d','\xd1','\xad','\x01','\xff','\xff', // 0x0068
    '\x02','\x00','\x5a','\xe4','\x98','\x01','\xff','\xff', // 0x0070
    '\x02','\xfe','\xff','\xff','\x02','\xfe','\xff','\xff', // 0x0078
    '\x02','\xfe','\xff','\xff','\x02','\xfe','\xff','\xff', // 0x0080
    '\x02','\xfe','\xff','\xff','\x03','\x01','\x28','\x94', // 0x0088
    '\x6b','\x94','\x2b','\xd4','\x2b','\x94','\x6b','\x94', // 0x0090
    '\x2b','\x54','\xab','\x55','\x00','\x00','\x3c','\x02', // 0x0098
    '\x04','\x0d','\x01','\x1d','\x01','\x2d','\x05','\x59', // 0x00a0
    '\x01','\x28','\x44','\x13','\x48','\x25','\x8d','\x50', // 0x00a8
    '\x03','\xac','\x52','\x05','\xa9','\x00','\x5a','\x01', // 0x00b0
    '\xb4','\x42','\x14','\xa1','\x09','\x24','\x51','\x06', // 0x00b8
    '\x28','\x00','\xff','\xff','\x12','\x00','\x44','\xab', // 0x00c0
    '\x00','\x2a','\x51','\x04','\x2a','\x41','\x14','\x22', // 0x00c8
    '\x09','\x16','\x00','\x0b','\x00','\x00','\x03','\x80', // 0x00d0
    '\xc0','\x60','\x60','\x04','\xe0','\xc0','\x80','\x00', // 0x00d8
    '\x00','\x15','\xc0','\xe0','\x00','\x00','\x03','\xe0', // 0x00e0
    '\xe0','\x02','\x00','\x00','\x11','\xc0','\xe0','\x00', // 0x00e8
    '\x00','\x15','\x02','\x00','\x00','\x02','\x01','\x00', // 0x00f0
    '\x02','\x00','\x02','\x00','\x01','\x00','\x01','\x00', // 0x00f8
    '\xc0','\xff','\xff','\x14','\xf0','\x80','\x00','\x00', // 0x0100
    '\x0f','\x63','\xe7','\xc6','\x8e','\x8c','\x8c','\x02', // 0x0108
    '\xdc','\xf9','\x71','\x00','\x03','\x0f','\x7c','\xf0', // 0x0110
    '\xc0','\xf0','\x7c','\x0f','\x03','\x00','\xff','\xff', // 0x0118
    '\x02','\x06','\x03','\x03','\x03','\xff','\xfe','\x00', // 0x0120
    '\x03','\xff','\xff','\x02','\x83','\x83','\x02','\x00', // 0x0128
    '\xff','\xff','\x02','\x06','\x03','\x03','\x03','\xff', // 0x0130
    '\xfe','\x00','\x00','\x02','\x7c','\xfe','\xdb','\x9b', // 0x0138
    '\x9b','\x02','\xde','\x5c','\x00','\x03','\xff','\xff', // 0x0140
    '\x02','\x83','\x83','\x02','\x00','\x7c','\xfe','\xc7', // 0x0148
    '\x83','\x83','\x02','\xc7','\xfe','\x7c','\x00','\x00', // 0x0150
    '\x02','\xce','\xdf','\x9b','\xbb','\xb3','\xf7','\xe6', // 0x0158
    '\x00','\x00','\x0a','\x80','\xc0','\xf8','\xfe','\xff', // 0x0160
    '\xff','\x17','\xfe','\xf0','\xc0','\x00','\x00','\x0e', // 0x0168
    '\x01','\x01','\x05','\x00','\x00','\x04','\x0c','\x0c', // 0x0170
    '\x02','\x0f','\x07','\x01','\x00','\x00','\x04','\x01', // 0x0178
    '\x01','\x02','\x00','\x00','\x04','\x01','\x01','\x02', // 0x0180
    '\x00','\x00','\x03','\x01','\x01','\x03','\x00','\x01', // 0x0188
    '\x01','\x02','\x00','\x00','\x04','\x01','\x01','\x02', // 0x0190
    '\x00','\x00','\x04','\x01','\x01','\x03','\x00','\x00', // 0x0198
    '\x05','\x01','\x01','\x03','\x00','\x00','\x03','\x01', // 0x01a0
    '\x01','\x04','\x00','\x00','\x05','\x01','\x01','\x05', // 0x01a8
    '\x00','\x00','\x07','\x80','\xe0','\xf0','\xfc','\xff', // 0x01b0
    '\xff','\x1f','\xfc','\xf0','\xc0','\x00','\x00','\x56', // 0x01b8
    '\x80','\xe0','\xf8','\xfe','\xff','\xff','\x27','\xfe', // 0x01c0
    '\xf8','\xe0','\x00','\x00','\x52','\x0f','\x1f','\x3f', // 0x01c8
    '\x3f','\x04','\x7f','\x7f','\x08','\xff','\xff','\x13', // 0x01d0
    '\x7f','\x7f','\x07','\x3f','\x3f','\x04','\x1f','\x1f', // 0x01d8
    '\x02','\x0f',*/
/*
// Saelig
    '\xff','\x0f','\x07','\x07','\x05','\x87','\xc7','\xc7', // 0x0008
    '\x04','\x87','\x07','\x07','\x0c','\x17','\x17','\x02', // 0x0010
    '\x67','\x0f','\xff','\xff','\x02','\x1f','\x07','\x07', // 0x0018
    '\x02','\x03','\x03','\x07','\x0b','\x03','\x03','\x02', // 0x0020
    '\x0b','\x03','\x03','\x02','\x0b','\x1b','\x07','\xff', // 0x0028
    '\xff','\x2a','\x03','\x03','\x04','\x1b','\x07','\xff', // 0x0030
    '\xff','\x02','\xc7','\x83','\x83','\x03','\x8b','\xc7', // 0x0038
    '\xff','\xff','\x04','\x83','\xbb','\xbb','\x03','\xff', // 0x0040
    '\x83','\xbb','\xbb','\x02','\x83','\xff','\x83','\xfb', // 0x0048
    '\xfb','\x02','\x83','\xfb','\xfb','\x02','\x83','\xff', // 0x0050
    '\xff','\x02','\x00','\x00','\x04','\x1e','\x3f','\x7f', // 0x0058
    '\xff','\xff','\x04','\x7f','\x3f','\x1e','\x00','\x00', // 0x0060
    '\x05','\x80','\x00','\x00','\x02','\x80','\xe0','\xfc', // 0x0068
    '\x00','\x00','\x03','\xff','\xff','\x02','\x00','\x00', // 0x0070
    '\x04','\x18','\x20','\x2e','\x0e','\x0e','\x02','\x2e', // 0x0078
    '\x0e','\x0e','\x02','\x2e','\x0e','\x0e','\x02','\x4e', // 0x0080
    '\x5e','\x9e','\x3e','\xff','\xff','\x03','\xc0','\xc0', // 0x0088
    '\x09','\xc2','\x80','\x00','\x02','\x00','\x05','\x1d', // 0x0090
    '\x03','\xff','\xff','\x02','\x03','\x01','\x01','\x02', // 0x0098
    '\x00','\x00','\x03','\xc0','\xc0','\x06','\x00','\x00', // 0x00a0
    '\x02','\x02','\x05','\x2d','\x03','\xff','\xff','\x02', // 0x00a8
    '\x00','\x00','\x06','\xff','\xff','\x02','\x00','\x00', // 0x00b0
    '\x04','\x06','\x01','\xff','\xff','\x02','\x03','\x01', // 0x00b8
    '\x00','\x00','\x04','\x80','\xc0','\xc0','\x06','\x00', // 0x00c0
    '\x00','\x03','\x02','\x06','\x00','\xff','\xff','\x02', // 0x00c8
    '\x00','\x00','\x0c','\x80','\xc0','\xe0','\xf0','\x38', // 0x00d0
    '\x0c','\x03','\xc0','\xf0','\xfe','\xff','\xff','\x03', // 0x00d8
    '\x00','\x00','\x03','\xff','\xff','\x02','\x3e','\x3c', // 0x00e0
    '\x3c','\x03','\xbc','\x3c','\x3c','\x02','\xbc','\x3c', // 0x00e8
    '\x3c','\x02','\xbc','\x3c','\x18','\x00','\x00','\x04', // 0x00f0
    '\x02','\x00','\xff','\xff','\x02','\x03','\x01','\x00', // 0x00f8
    '\x00','\x03','\x80','\x60','\x60','\x06','\x00','\x00', // 0x0100
    '\x04','\x04','\x00','\xff','\xff','\x02','\x00','\x00', // 0x0108
    '\x04','\xc3','\x82','\x60','\x60','\x0a','\x70','\x78', // 0x0110
    '\xff','\xff','\x02','\x00','\x00','\x06','\xff','\xff', // 0x0118
    '\x02','\x00','\x00','\x06','\xff','\xff','\x02','\x00', // 0x0120
    '\x00','\x04','\xc8','\x80','\x1f','\x3f','\xbf','\x3f', // 0x0128
    '\x3f','\x04','\x00','\x00','\x04','\x02','\x00','\xff', // 0x0130
    '\xff','\x02','\x00','\x00','\x04','\x80','\xc0','\xe0', // 0x0138
    '\xf0','\xf8','\xfc','\xfe','\xff','\xff','\x02','\x3f', // 0x0140
    '\x07','\x81','\xe0','\xf8','\xff','\xff','\x07','\x00', // 0x0148
    '\x00','\x03','\xff','\xff','\x02','\xf0','\x70','\xf0', // 0x0150
    '\xf0','\x02','\x70','\xf0','\xf0','\x02','\x70','\x70', // 0x0158
    '\x02','\xf0','\xf0','\x02','\xb0','\xf0','\xf0','\x02', // 0x0160
    '\x70','\x70','\x03','\xf8','\x7c','\xff','\xff','\x02', // 0x0168
    '\x7c','\xf8','\xf0','\x70','\x70','\x02','\xf0','\xf0', // 0x0170
    '\x07','\x70','\x70','\x02','\xf0','\xf0','\x02','\x38', // 0x0178
    '\xfc','\xff','\x7f','\x7c','\xf8','\xf0','\xf0','\x02', // 0x0180
    '\x70','\x70','\x03','\xf0','\x30','\xf0','\xf0','\x02', // 0x0188
    '\x70','\x70','\x02','\xf0','\xf0','\x02','\x70','\x70', // 0x0190
    '\x02','\xf0','\xff','\xff','\x02','\x70','\x70','\x02', // 0x0198
    '\xf0','\xf0','\x02','\xb0','\xf0','\xff','\x7f','\x70', // 0x01a0
    '\xf0','\xf0','\x02','\x70','\x70','\x03','\xff','\xff', // 0x01a8
    '\x02','\x3c','\x38','\x30','\x30','\x0b','\x00','\x00', // 0x01b0
    '\x04','\x08','\x00','\xff','\xff','\x02','\xfc','\xf8', // 0x01b8
    '\xf8','\x1a','\xfc','\xff','\xff','\x03','\x78','\x77', // 0x01c0
    '\xf7','\xf8','\xff','\xf0','\xff','\x7f','\x70','\xff', // 0x01c8
    '\xf0','\xff','\xf8','\xf7','\xf7','\x02','\xc0','\xff', // 0x01d0
    '\xf8','\xf7','\xf7','\x02','\xf8','\xff','\xf8','\xf5', // 0x01d8
    '\xf5','\x02','\xf4','\xff','\xff','\x05','\xf8','\xf5', // 0x01e0
    '\xf5','\x02','\xf4','\xff','\xf0','\xff','\x78','\xf5', // 0x01e8
    '\xf5','\x02','\xf4','\xff','\xf8','\xf7','\xf7','\x03', // 0x01f0
    '\xff','\xf0','\xf6','\xff','\xf0','\x7f','\x7f','\x02', // 0x01f8
    '\xf8','\xf7','\xf7','\x02','\xf8','\xff','\xf0','\xff', // 0x0200
    '\xff','\x02','\xf0','\xff','\xf0','\x7f','\x78','\xf7', // 0x0208
    '\xf7','\x02','\xff','\xf6','\xf5','\xf5','\x02','\xfb', // 0x0210
    '\xff','\xff','\x02','\xf0','\xf0','\x10','\xf8','\xf8', // 0x0218
    '\x02','\xfe','\xff','\xff','\x21','\xfe','\xfc','\x30', // 0x0220
    '\x03','\x87','\x03','\x30','\xfc','\xfe','\xff','\xff', // 0x0228
    '\x02','\x03','\x03','\x02','\xe7','\xf3','\xf3','\x02', // 0x0230
    '\xe3','\x07','\x0f','\xff','\xff','\x02','\x03','\x03', // 0x0238
    '\x02','\xe7','\xf3','\xf3','\x02','\xff','\x0f','\x07', // 0x0240
    '\xe3','\xf3','\xf3','\x02','\xe3','\x07','\x0f','\xff', // 0x0248
    '\xf3','\x00','\x00','\x02','\xf3','\xf3','\x02','\xff', // 0x0250
    '\x0f','\x07','\xe3','\xf3','\xf3','\x02','\xe3','\x07', // 0x0258
    '\x0f','\xff','\xff','\x02','\x00','\x00','\x02','\xff', // 0x0260
    '\xff','\x02','\x67','\x23','\x33','\x93','\x93','\x02', // 0x0268
    '\x03','\x07','\xff','\xff','\x02','\x00','\x00','\x02', // 0x0270
    '\xe7','\xf3','\xf3','\x02','\xe3','\x07','\x0f','\xff', // 0x0278
    '\xff','\x17','\x7f','\x7f','\x20','\x79','\x78','\x7c', // 0x0280
    '\x7f','\x7f','\x03','\x7c','\x78','\x79','\x7f','\x7f', // 0x0288
    '\x02','\x40','\x40','\x02','\x7c','\x79','\x79','\x02', // 0x0290
    '\x78','\x7c','\x7e','\x7f','\x7f','\x02','\x78','\x78', // 0x0298
    '\x02','\x7f','\x7f','\x04','\x7e','\x7c','\x78','\x79', // 0x02a0
    '\x79','\x02','\x78','\x7c','\x7e','\x7f','\x7f','\x02', // 0x02a8
    '\x7c','\x78','\x79','\x79','\x02','\x7f','\x7e','\x7c', // 0x02b0
    '\x78','\x79','\x79','\x02','\x78','\x7c','\x7e','\x7f', // 0x02b8
    '\x7f','\x02','\x78','\x78','\x02','\x7f','\x7f','\x02', // 0x02c0
    '\x7c','\x78','\x79','\x79','\x03','\x7c','\x78','\x7b', // 0x02c8
    '\x7f','\x78','\x78','\x02','\x7c','\x79','\x79','\x02', // 0x02d0
    '\x78','\x7c','\x7e','\x7f','\x7f','\x17','\x00','\x00', // 0x02d8
    '\x80',
*/

const unsigned char tian1[] PROGMEM = {
    '\x00','\x00','\x15','\x80','\xe0','\x38','\x18','\x0c', // 0x0008
    '\x84','\x44','\x24','\x32','\x32','\x02','\x22','\x2a', // 0x0010
    '\x22','\x34','\x74','\xec','\x88','\x70','\xf0','\x40', // 0x0018
    '\x60','\x40','\x40','\x02','\x00','\x60','\x40','\x60', // 0x0020
    '\x60','\x02','\x40','\x40','\x02','\x60','\xc0','\x40', // 0x0028
    '\xc0','\xc0','\x08','\xe0','\xe0','\x02','\xf8','\x78', // 0x0030
    '\x38','\x3c','\x1c','\x12','\x1a','\x0e','\x6c','\xcc', // 0x0038
    '\x18','\x30','\xc0','\x00','\x00','\x1b','\xc0','\xb0', // 0x0040
    '\xb8','\x4c','\x64','\xc2','\x02','\x00','\x01','\x81', // 0x0048
    '\xc3','\x6b','\x7d','\x35','\x35','\x02','\x01','\x41', // 0x0050
    '\x41','\x02','\x71','\x76','\x76','\x02','\x6a','\x3c', // 0x0058
    '\x00','\x00','\x16','\x07','\x17','\x70','\xa0','\xc0', // 0x0060
    '\x4f','\x9e','\xa8','\x90','\x10','\x00','\x00','\x07', // 0x0068
    '\x03','\x80','\x88','\x88','\x02','\x28','\x2a','\x2a', // 0x0070
    '\x02','\x4a','\x12','\x04','\x00','\x00','\x02','\x84', // 0x0078
    '\x56','\x52','\x52','\x04','\x12','\x12','\x03','\x16', // 0x0080
    '\x16','\x02','\x07','\x03','\x01','\x00','\x80','\x80', // 0x0088
    '\x02','\x40','\xa0','\x30','\x98','\xdc','\x67','\x31', // 0x0090
    '\x18','\x06','\x01','\x00','\x00','\x1b','\x7f','\x81', // 0x0098
    '\x01','\x03','\x0f','\x07','\x0f','\x0e','\x1e','\x21', // 0x00a0
    '\xc0','\x00','\x00','\x25','\xc0','\x30','\xd9','\x6d', // 0x00a8
    '\x06','\x06','\x02','\x7a','\xde','\xed','\x0f','\x00', // 0x00b0
    '\x02','\x06','\x1f','\x3f','\x3d','\x3f','\x1f','\x07', // 0x00b8
    '\xf0','\x3c','\x08','\x00','\x00','\x05','\xf0','\xfc', // 0x00c0
    '\x00','\x1e','\x3b','\x3f','\x7f','\x3f','\x1e','\x06', // 0x00c8
    '\x02','\x00','\x04','\x8e','\xf4','\x28','\x01','\x4f', // 0x00d0
    '\xfd','\xb0','\x04','\x04','\x03','\x14','\x34','\x74', // 0x00d8
    '\xf4','\xf4','\x02','\xfc','\x58','\x48','\x08','\x08', // 0x00e0
    '\x05','\x88','\xd0','\xd0','\x02','\xf0','\xa0','\xa0', // 0x00e8
    '\x02','\x60','\x40','\x40','\x03','\x80','\x80','\x02', // 0x00f0
    '\x00','\x00','\x07','\x01','\x07','\x0c','\x0f','\x32', // 0x00f8
    '\x45','\xc6','\x07','\x83','\x83','\x02','\x02','\x04', // 0x0100
    '\x78','\x80','\x00','\x00','\x1a','\x30','\xbc','\xf2', // 0x0108
    '\xaf','\x03','\x00','\x1e','\xbf','\x4f','\xe0','\xb0', // 0x0110
    '\xc0','\x27','\x37','\xff','\x00','\x00','\x09','\xdf', // 0x0118
    '\xc1','\x00','\x00','\x07','\x07','\xcf','\xc0','\x00', // 0x0120
    '\x00','\x09','\x39','\xf6','\xbf','\x0d','\x00','\xa0', // 0x0128
    '\xf7','\x5f','\x22','\x00','\x00','\x02','\xc0','\x80', // 0x0130
    '\x01','\x02','\x03','\x7f','\x0d','\x05','\x00','\x00', // 0x0138
    '\x04','\x04','\x31','\x5a','\x9b','\x15','\x15','\x02', // 0x0140
    '\x04','\x00','\x00','\x04','\x15','\x6f','\xb5','\x2b', // 0x0148
    '\x3a','\x04','\x08','\x08','\x03','\x58','\xf0','\xf0', // 0x0150
    '\x03','\x88','\x8c','\x07','\x03','\x0c','\x9f','\xf8', // 0x0158
    '\x7c','\x18','\x07','\x00','\x00','\x1b','\x06','\x05', // 0x0160
    '\x02','\x0e','\x18','\x3c','\x40','\x43','\x89','\x0b', // 0x0168
    '\x7c','\x90','\x60','\xc1','\x09','\xc0','\x00','\x08', // 0x0170
    '\x20','\x20','\x02','\x10','\x40','\x20','\x60','\x03', // 0x0178
    '\x07','\x06','\x8c','\xf8','\x7c','\x06','\x07','\x03', // 0x0180
    '\x01','\x00','\x80','\x50','\xc0','\xd0','\xc0','\xc0', // 0x0188
    '\x02','\x70','\x40','\x39','\x31','\x89','\xc0','\x7c', // 0x0190
    '\x8e','\x55','\x8f','\x58','\xde','\x7d','\x8f','\x81', // 0x0198
    '\x01','\x40','\x40','\x04','\xc0','\x40','\x10','\x00', // 0x01a0
    '\x20','\x60','\xf0','\xa1','\x01','\x00','\x00','\x05', // 0x01a8
    '\xf0','\x80','\x00','\x07','\x0f','\x0e','\x0b','\x08', // 0x01b0
    '\x00','\x00','\x02','\x06','\x08','\x15','\x24','\x47', // 0x01b8
    '\x85','\x06','\x03','\x02','\x02','\x02','\x01','\x00', // 0x01c0
    '\x00','\x1e','\xe0','\x10','\x10','\x02','\x08','\x28', // 0x01c8
    '\x08','\x24','\x24','\x02','\x34','\xb4','\xb4','\x02', // 0x01d0
    '\xa5','\xa6','\x86','\x8f','\x42','\x5e','\x0d','\x29', // 0x01d8
    '\x3e','\x56','\x76','\x38','\x3a','\x38','\xc8','\xcc', // 0x01e0
    '\xc6','\xc6','\x02','\x83','\x83','\x02','\x87','\x8e', // 0x01e8
    '\xdc','\xb8','\xb0','\x60','\xe8','\x84','\xcd','\xc8', // 0x01f0
    '\x4c','\x2c','\x1e','\x1c','\x14','\x8c','\x4a','\x46', // 0x01f8
    '\x23','\x12','\x9a','\x0a','\x25','\x24','\x24','\x02', // 0x0200
    '\x15','\x35','\x04','\x08','\x08','\x03','\x10','\xf0', // 0x0208
    '\x04','\x18','\x05','\x0c','\x9e','\x07','\x1a','\x07', // 0x0210
    '\x0e','\x0c','\x10','\xe0','\x00','\x76','\xfb','\xbe', // 0x0218
    '\x1c','\x00','\x04','\x86','\xd2','\x2b','\x62','\xe2', // 0x0220
    '\x13','\x20','\x7a','\x1a','\x3a','\x2f','\x76','\x28', // 0x0228
    '\x30','\x80','\x00','\x00','\x1a','\x7c','\x83','\x03', // 0x0230
    '\x02','\x02','\x03','\x3f','\xc1','\x01','\x01','\x04', // 0x0238
    '\x9e','\x61','\x80','\x00','\x80','\x80','\x03','\xff', // 0x0240
    '\x00','\x00','\x06','\x01','\x01','\x04','\x00','\x01', // 0x0248
    '\x01','\x06','\x00','\x00','\x05','\x01','\x01','\x03', // 0x0250
    '\x00','\x00','\x04','\x3e','\xc1','\x41','\xc1','\x3d', // 0x0258
    '\x43','\xc0','\x41','\xc1','\x71','\x8e','\xc1','\x41', // 0x0260
    '\xc1','\xc1','\x02','\x42','\x42','\x02','\x3c','\x03', // 0x0268
    '\x00','\x00','\x03','\x07','\x06','\x03','\x0d','\x1d', // 0x0270
    '\x0e','\x3d','\x1e','\xef','\x17','\x17','\x02','\x1d', // 0x0278
    '\x17','\x10','\xec','\x07','\x04','\x04','\x03','\x08', // 0x0280
    '\xf0','\x08','\x04','\x04','\x03','\x28','\x30','\xf0', // 0x0288
    '\x60','\x30','\x1b','\x0e','\x00','\x00','\x1a','\x03', // 0x0290
    '\x02','\x06','\x09','\x0b','\x05','\x00','\x01','\x03', // 0x0298
    '\x05','\x05','\x02','\x02','\x00','\x00','\x02','\x03', // 0x02a0
    '\x04','\x05','\x02','\x00','\x00','\x20','\x01','\x00', // 0x02a8
    '\x00','\x04','\x03','\x01','\x00','\x00','\x02','\x01', // 0x02b0
    '\x03','\x00','\x00','\x12','\x07','\x08','\x08','\x02', // 0x02b8
    '\x18','\x28','\x39','\x06','\x04','\x1c','\x24','\x44', // 0x02c0
    '\x3d','\x06','\x0a','\x32','\x3e','\x02','\x01','\x00', // 0x02c8
    '\x00','\x11',
};

const unsigned char tian2[] PROGMEM = {
    '\x00','\x00','\x2a','\x80','\xc0','\x40','\x60','\x60', // 0x0008
    '\x02','\x30','\x30','\x03','\x38','\x18','\x18','\x02', // 0x0010
    '\x14','\x14','\x03','\x16','\x12','\x12','\x04','\x13', // 0x0018
    '\x13','\x02','\x23','\x23','\x02','\x21','\x21','\x03', // 0x0020
    '\x23','\x43','\x43','\x03','\xc2','\x82','\x82','\x03', // 0x0028
    '\x02','\x02','\x03','\x06','\x06','\x02','\x04','\x04', // 0x0030
    '\x04','\x0c','\x08','\x08','\x03','\x18','\x10','\x10', // 0x0038
    '\x02','\x30','\x20','\x20','\x02','\x60','\x40','\xc0', // 0x0040
    '\xc0','\x02','\x80','\x80','\x02','\x00','\x00','\x37', // 0x0048
    '\x80','\x80','\x04','\xc0','\xe0','\xa0','\x90','\x98', // 0x0050
    '\x8c','\x84','\x82','\x83','\x81','\x80','\x00','\x00', // 0x0058
    '\x20','\x01','\x01','\x03','\x83','\xc6','\xfc','\xc0', // 0x0060
    '\x20','\x18','\x0c','\x04','\x02','\x03','\x01','\x01', // 0x0068
    '\x07','\x02','\x1a','\xe2','\x04','\x0c','\x19','\xf9', // 0x0070
    '\x33','\xe2','\x06','\x04','\x0c','\x18','\x10','\x30', // 0x0078
    '\x20','\x60','\x40','\x80','\x80','\x02','\x00','\x00', // 0x0080
    '\x19','\x80','\xc0','\x60','\x20','\x30','\x10','\x18', // 0x0088
    '\x08','\x0c','\x04','\x06','\x02','\x02','\x02','\x03', // 0x0090
    '\x01','\x01','\x03','\x00','\x00','\x0c','\x01','\x01', // 0x0098
    '\x08','\x03','\x03','\x02','\x02','\x02','\x04','\x06', // 0x00a0
    '\x06','\x02','\x04','\x04','\x03','\x0c','\x0c','\x02', // 0x00a8
    '\x08','\x08','\x02','\x18','\x18','\x02','\x10','\x30', // 0x00b0
    '\x30','\x02','\x20','\x20','\x04','\x30','\x18','\x08', // 0x00b8
    '\x0c','\xe6','\xdb','\xc7','\xc1','\xc0','\x40','\x40', // 0x00c0
    '\x05','\xe0','\xe0','\x02','\xa0','\xa0','\x02','\xe0', // 0x00c8
    '\x70','\x50','\x70','\x28','\x28','\x02','\x3f','\x1c', // 0x00d0
    '\x1a','\x2b','\xc5','\x02','\x01','\x00','\x00','\x0a', // 0x00d8
    '\x07','\x0e','\x10','\x20','\xc0','\x80','\x00','\x00', // 0x00e0
    '\x0d','\x80','\xc0','\x40','\xf0','\x08','\x04','\x06', // 0x00e8
    '\x0f','\xf8','\x20','\x20','\x07','\x40','\x40','\x04', // 0x00f0
    '\x80','\x80','\x03','\x00','\x00','\x09','\x80','\x80', // 0x00f8
    '\x03','\x40','\x40','\x07','\xc0','\x80','\x80','\x02', // 0x0100
    '\x00','\x00','\x11','\x40','\x20','\x10','\x10','\x02', // 0x0108
    '\x18','\x08','\x08','\x02','\x0c','\x0c','\x02','\x04', // 0x0110
    '\x05','\x0d','\x09','\x19','\x11','\x71','\xc1','\x81', // 0x0118
    '\x01','\x01','\x02','\x00','\x00','\x0e','\x01','\x0f', // 0x0120
    '\xf0','\x00','\x00','\x03','\x80','\xc0','\x30','\x98', // 0x0128
    '\x44','\xa6','\xf2','\x51','\x95','\x15','\x36','\x6e', // 0x0130
    '\xbd','\xfe','\xf8','\x80','\x00','\x00','\x09','\x1e', // 0x0138
    '\x7f','\xc0','\x08','\x11','\x13','\x16','\x14','\x0c', // 0x0140
    '\x07','\x00','\x00','\x0e','\xc1','\x63','\x12','\x0c', // 0x0148
    '\xcc','\xfc','\x1e','\x07','\x03','\x01','\x00','\x00', // 0x0150
    '\x0b','\x81','\xc3','\x7e','\x18','\x00','\x00','\x04', // 0x0158
    '\x80','\x80','\x03','\x40','\x40','\x03','\x20','\x20', // 0x0160
    '\x02','\xf0','\xf0','\x03','\x38','\x38','\x02','\x74', // 0x0168
    '\xbe','\x2e','\xaf','\x7d','\x55','\xbd','\x2b','\xd3', // 0x0170
    '\xa5','\xcb','\x36','\xec','\xb9','\xff','\xf0','\x00', // 0x0178
    '\x00','\x0a','\x80','\x80','\x03','\xc0','\x40','\x60', // 0x0180
    '\x20','\xff','\x10','\x10','\x02','\x0c','\x1f','\xf8', // 0x0188
    '\x0e','\x39','\xa8','\xe3','\x20','\xf9','\x1f','\xce', // 0x0190
    '\xc0','\x00','\x03','\xfc','\xff','\x07','\x00','\x00', // 0x0198
    '\x09','\xfc','\x06','\x03','\x07','\x1c','\x70','\xc0', // 0x01a0
    '\x1c','\x64','\x4c','\x88','\x88','\x02','\x08','\x18', // 0x01a8
    '\x10','\x10','\x02','\x30','\x20','\x20','\x03','\x40', // 0x01b0
    '\x40','\x04','\xc7','\x8c','\x88','\x98','\x90','\x91', // 0x01b8
    '\x13','\x12','\x12','\x06','\x0a','\x0a','\x05','\x06', // 0x01c0
    '\x07','\x07','\x02','\x05','\x02','\x02','\x03','\x03', // 0x01c8
    '\x01','\x01','\x03','\x00','\x00','\x02','\x80','\x80', // 0x01d0
    '\x02','\xc0','\xf8','\xfc','\xff','\xbf','\x0f','\x27', // 0x01d8
    '\xc4','\xe8','\x14','\x17','\xbc','\xd1','\xf0','\x10', // 0x01e0
    '\x0d','\x0e','\xf0','\x03','\x3e','\x07','\xfc','\x07', // 0x01e8
    '\xff','\x04','\x04','\x05','\x06','\x02','\x0a','\x0a', // 0x01f0
    '\x02','\x05','\x05','\x02','\xf5','\xfa','\x06','\x02', // 0x01f8
    '\x02','\x02','\x82','\xc2','\x7f','\x00','\xc0','\x70', // 0x0200
    '\x1e','\xff','\x07','\xfa','\x49','\x21','\xa1','\xf3', // 0x0208
    '\xdc','\x3f','\x01','\x80','\x70','\xef','\x3f','\x00', // 0x0210
    '\x00','\x0a','\x03','\x06','\x08','\x10','\x30','\x60', // 0x0218
    '\x40','\xc0','\x80','\x80','\x02','\x00','\x00','\x10', // 0x0220
    '\x08','\x00','\x10','\x11','\x11','\x03','\x19','\x0f', // 0x0228
    '\x00','\x00','\x0c','\xe0','\x30','\x18','\x08','\x0c', // 0x0230
    '\x06','\x02','\x03','\x01','\x01','\x02','\x00','\x00', // 0x0238
    '\x03','\xc0','\xf0','\xff','\xf2','\xdb','\x0c','\x03', // 0x0240
    '\x87','\x7f','\x03','\x8c','\x90','\x50','\x31','\x1f', // 0x0248
    '\xc3','\xf0','\xdf','\x38','\xc7','\x3c','\x07','\x80', // 0x0250
    '\x80','\x04','\x40','\x40','\x03','\x60','\x20','\x30', // 0x0258
    '\x10','\x1b','\x0f','\x0c','\x06','\x83','\x81','\x80', // 0x0260
    '\xc0','\x40','\x3f','\x5e','\x40','\x40','\x02','\x43', // 0x0268
    '\x47','\x4e','\x5f','\x52','\x59','\x48','\x24','\x32', // 0x0270
    '\x0d','\x07','\x01','\x00','\x00','\x14','\x01','\x01', // 0x0278
    '\x02','\x03','\x02','\x06','\x06','\x02','\x04','\x0c', // 0x0280
    '\x0c','\x02','\x08','\x18','\x18','\x02','\x10','\x10', // 0x0288
    '\x02','\x30','\x20','\x20','\x03','\x60','\x60','\x02', // 0x0290
    '\x40','\x40','\x04','\xc0','\xc0','\x0c','\x40','\x41', // 0x0298
    '\x40','\x40','\x03','\x60','\x20','\x20','\x03','\x30', // 0x02a0
    '\x10','\x18','\x1c','\x17','\x23','\x20','\x23','\x27', // 0x02a8
    '\x2e','\x2f','\x37','\x3b','\x2f','\x2d','\x2c','\x2e', // 0x02b0
    '\x3a','\x17','\x15','\x0a','\x0d','\x0e','\x07','\x04', // 0x02b8
    '\x04','\x03','\x06','\x06','\x02','\x02','\x02','\x04', // 0x02c0
    '\x03','\x03','\x02','\x01','\x01','\x08','\x00','\x00', // 0x02c8
    '\x1b',
};

const unsigned char tian3[] PROGMEM = {
    '\x00','\x00','\x25','\xc0','\x20','\x30','\xdc','\x46', // 0x0008
    '\x83','\x07','\x79','\x81','\x01','\x01','\x02','\x72', // 0x0010
    '\x8a','\x8a','\x02','\x89','\x69','\x11','\x01','\xa2', // 0x0018
    '\xc2','\x82','\x41','\x71','\x41','\x41','\x02','\xc2', // 0x0020
    '\xa2','\x02','\x01','\x01','\x03','\xe1','\x42','\x42', // 0x0028
    '\x03','\x72','\x81','\x81','\x02','\xc1','\x62','\x02', // 0x0030
    '\x32','\x29','\x29','\x02','\x1a','\x02','\xfc','\x00', // 0x0038
    '\x00','\x4e','\x3c','\x66','\xc3','\x00','\x00','\x02', // 0x0040
    '\x0f','\x10','\x10','\x02','\x0f','\x00','\x00','\x02', // 0x0048
    '\x01','\x7e','\x80','\x00','\x00','\x04','\x30','\xce', // 0x0050
    '\x03','\x01','\x00','\x00','\x04','\x70','\xf8','\xf8', // 0x0058
    '\x03','\x71','\x86','\x7b','\x01','\x70','\xf8','\xf8', // 0x0060
    '\x03','\x70','\x00','\x00','\x02','\x01','\x81','\x7e', // 0x0068
    '\x00','\x00','\x04','\xc0','\x3f','\x00','\x00','\x07', // 0x0070
    '\x80','\x80','\x03','\xe0','\x58','\x6c','\xf4','\x1a', // 0x0078
    '\x0e','\x00','\x00','\x40','\x07','\x0f','\x30','\xe0', // 0x0080
    '\x0e','\x11','\x11','\x02','\xcf','\x20','\x20','\x02', // 0x0088
    '\xc0','\x3f','\xc0','\x00','\x00','\x02','\x04','\x02', // 0x0090
    '\x01','\x09','\x09','\x02','\xf9','\xeb','\xc3','\xce', // 0x0098
    '\x84','\x84','\x03','\x82','\x83','\x81','\x83','\x82', // 0x00a0
    '\x94','\x94','\x02','\xa4','\xb4','\xb2','\xd2','\x92', // 0x00a8
    '\x11','\x18','\x09','\x05','\x02','\x00','\x00','\x02', // 0x00b0
    '\xf1','\x1e','\x00','\x00','\x06','\x0f','\xd8','\x32', // 0x00b8
    '\xe6','\x27','\x29','\x15','\x0a','\x07','\x00','\x00', // 0x00c0
    '\x44','\x03','\x04','\x3c','\xc0','\x41','\x86','\xc4', // 0x00c8
    '\x23','\x60','\x1f','\xe0','\x00','\x00','\x02','\xc0', // 0x00d0
    '\x40','\x00','\x00','\x02','\x7f','\xff','\xbf','\x3f', // 0x00d8
    '\x3f','\x02','\x7f','\x7f','\x02','\x3c','\x7c','\x7c', // 0x00e0
    '\x02','\xff','\xff','\x02','\x7f','\x04','\x04','\x03', // 0x00e8
    '\x07','\x00','\x00','\x02','\x80','\x5e','\x51','\xd1', // 0x00f0
    '\x09','\x06','\xe0','\x3f','\x10','\xf0','\xf0','\x02', // 0x00f8
    '\xe0','\xa0','\x90','\x4c','\x33','\x0c','\x03','\x00', // 0x0100
    '\x00','\x4c','\x3f','\xe0','\x20','\xe0','\xbf','\x90', // 0x0108
    '\x90','\x03','\x1f','\xf0','\x30','\x12','\x15','\x15', // 0x0110
    '\x02','\x13','\x30','\x32','\x54','\x55','\x55','\x04', // 0x0118
    '\x35','\x35','\x02','\xe5','\x45','\xf5','\x32','\x50', // 0x0120
    '\x50','\x03','\x30','\x30','\x02','\x10','\x11','\x11', // 0x0128
    '\x04','\xf0','\x18','\x07','\x04','\x04','\x02','\x03', // 0x0130
    '\x03','\x02','\x00','\x00','\x54','\xdf','\x30','\x0f', // 0x0138
    '\x10','\xf3','\x23','\x23','\x02','\xe1','\x7f','\x41', // 0x0140
    '\x41','\x02','\x47','\x47','\x04','\xc7','\xc1','\x41', // 0x0148
    '\x47','\x47','\x05','\xc8','\xd0','\x68','\x67','\x67', // 0x0150
    '\x04','\xe1','\xe7','\x27','\x27','\x03','\x21','\x21', // 0x0158
    '\x02','\x3f','\x00','\x00','\x5a','\x0f','\x0e','\x18', // 0x0160
    '\x17','\x0a','\x03','\x00','\x01','\x01','\x02','\xfe', // 0x0168
    '\xc2','\xfe','\x02','\x02','\x02','\x01','\x01','\x02', // 0x0170
    '\x00','\x00','\x08','\x01','\xfe','\xe2','\xfe','\x02', // 0x0178
    '\x01','\x00','\x00','\x6a','\x78','\xff','\xf9','\xff', // 0x0180
    '\xf8','\xf8','\x02','\xd0','\xf0','\xf0','\x02','\xe0', // 0x0188
    '\x00','\x00','\x06','\x7c','\x7f','\x7c','\x7f','\x7c', // 0x0190
    '\xf8','\xfc','\xec','\x78','\x30','\x00','\x00','\x34', // 0x0198
};

const unsigned char tian4[] PROGMEM = {
    '\x00','\x00','\x31','\x80','\xc0','\x60','\x30','\x18', // 0x0008
    '\x0c','\x0e','\x06','\x07','\x03','\x03','\x02','\x73', // 0x0010
    '\x8b','\x9b','\x8b','\x57','\x2e','\xbc','\xf0','\xc0', // 0x0018
    '\xe0','\xf0','\xb0','\xb8','\xec','\xcc','\x9c','\x38', // 0x0020
    '\x30','\x30','\x02','\x60','\xe0','\xc0','\x00','\x00', // 0x0028
    '\x5b','\xe0','\xf8','\x3c','\x0f','\x03','\x00','\x00', // 0x0030
    '\x02','\x80','\xc0','\x60','\x20','\x10','\x08','\x08', // 0x0038
    '\x02','\x84','\x84','\x02','\x42','\x42','\x02','\x23', // 0x0040
    '\x21','\x11','\xd1','\xd9','\x38','\xfc','\xbc','\xbc', // 0x0048
    '\x02','\x9e','\x1f','\x0d','\x8f','\x08','\x88','\x88', // 0x0050
    '\x02','\xe0','\xfd','\x3f','\x06','\x00','\x00','\x56', // 0x0058
    '\xf8','\xfe','\x87','\xc3','\x61','\x23','\x20','\x20', // 0x0060
    '\x02','\x38','\xfc','\xc7','\x07','\x1a','\xb2','\xe2', // 0x0068
    '\xc2','\x01','\x81','\xc1','\x87','\x9f','\x0e','\x00', // 0x0070
    '\x00','\x03','\x07','\x03','\x03','\x02','\x01','\x01', // 0x0078
    '\x04','\x03','\x87','\xfe','\xfc','\x0e','\x0f','\x03', // 0x0080
    '\x00','\x00','\x5a','\x0f','\x3f','\x79','\xe0','\xc0', // 0x0088
    '\xd0','\xd1','\xc2','\xcc','\xc1','\xc3','\x83','\x03', // 0x0090
    '\x01','\x00','\x00','\x02','\x03','\x0f','\x3c','\xf9', // 0x0098
    '\x31','\x61','\xb1','\xe1','\xe2','\xe6','\x66','\xa4', // 0x00a0
    '\xe4','\x7c','\x1e','\x0f','\x03','\x01','\x00','\x00', // 0x00a8
    '\x5a','\x80','\xc0','\xf0','\x78','\x58','\x18','\x18', // 0x00b0
    '\x02','\x1c','\x36','\x26','\x67','\xc3','\xe3','\x63', // 0x00b8
    '\x33','\x11','\x1b','\x0f','\x06','\xfc','\x7c','\x0c', // 0x00c0
    '\xcc','\x4d','\x7e','\x66','\xa7','\x3f','\x37','\x0f', // 0x00c8
    '\xdf','\x33','\x70','\xf0','\xf0','\x02','\x38','\x1c', // 0x00d0
    '\x0c','\x0c','\x03','\x1c','\x38','\xf8','\xe0','\xe0', // 0x00d8
    '\x02','\xc0','\x00','\x00','\x50','\x7c','\xff','\xc7', // 0x00e0
    '\x00','\x0c','\x02','\x18','\x04','\x00','\x00','\x02', // 0x00e8
    '\xc0','\xa0','\xc1','\xff','\xff','\x02','\x84','\x8c', // 0x00f0
    '\x0c','\x04','\x04','\x02','\x02','\x01','\x00','\x0f', // 0x00f8
    '\x1d','\x10','\x10','\x02','\x18','\x1d','\x07','\x00', // 0x0100
    '\x00','\x02','\x03','\x87','\xec','\x7f','\x07','\x00', // 0x0108
    '\x00','\x04','\x80','\xa0','\xec','\xf1','\x7e','\x1f', // 0x0110
    '\x07','\x00','\x00','\x51','\x01','\x03','\x07','\x06', // 0x0118
    '\xe6','\xfc','\x3c','\xe4','\x04','\x06','\x03','\x00', // 0x0120
    '\x00','\x03','\x1f','\x03','\xc7','\xfe','\x38','\x30', // 0x0128
    '\x30','\x08','\x18','\x18','\x02','\x0c','\x0c','\x02', // 0x0130
    '\x06','\x03','\x07','\x07','\x02','\x0e','\x0c','\x0c', // 0x0138
    '\x02','\x0e','\x0f','\x0e','\x0f','\x07','\x01','\x00', // 0x0140
    '\x00','\x58','\x1f','\x3f','\x3c','\x7f','\x60','\xe0', // 0x0148
    '\xc0','\xc0','\x02','\xe0','\xe0','\x02','\x78','\x3f', // 0x0150
    '\x0f','\x01','\x00','\x00','\x49',
};

const unsigned char tian5[] PROGMEM = {
    '\xff','\x01','\x01','\x7e','\xff','\xff','\x02','\x00', // 0x0008
    '\x00','\x22','\x80','\x60','\x20','\xb0','\x50','\x18', // 0x0010
    '\x18','\x02','\x10','\x30','\x20','\x60','\xc0','\x80', // 0x0018
    '\x00','\x00','\x05','\x80','\x80','\x04','\xc0','\x60', // 0x0020
    '\x60','\x02','\x20','\x30','\x30','\x02','\x98','\x18', // 0x0028
    '\x98','\x88','\x08','\x4c','\x4c','\x04','\x0c','\x0c', // 0x0030
    '\x05','\x08','\x08','\x05','\x18','\x18','\x02','\x10', // 0x0038
    '\x30','\x30','\x02','\x60','\x60','\x02','\xc0','\x80', // 0x0040
    '\x00','\x00','\x24','\xff','\xff','\x02','\x00','\x00', // 0x0048
    '\x09','\x40','\xc0','\xc0','\x03','\x80','\x80','\x03', // 0x0050
    '\x00','\x00','\x0e','\xc0','\x78','\x0e','\x03','\x01', // 0x0058
    '\xc0','\x60','\x3f','\x06','\x00','\x00','\x02','\x80', // 0x0060
    '\x40','\x20','\x30','\x19','\x07','\x7c','\xfc','\xc2', // 0x0068
    '\x23','\x31','\x11','\x18','\x08','\x08','\x02','\x0c', // 0x0070
    '\x00','\x06','\x03','\x01','\x01','\x02','\x00','\x00', // 0x0078
    '\x07','\xc0','\xe0','\x38','\x8c','\xc2','\x23','\x19', // 0x0080
    '\x0c','\x06','\x06','\x02','\x02','\x00','\x00','\x06', // 0x0088
    '\x10','\x62','\xc2','\x05','\x0b','\x16','\x1c','\x70', // 0x0090
    '\xc0','\x00','\x00','\x1f','\xff','\xff','\x02','\x00', // 0x0098
    '\x00','\x02','\xe0','\x00','\x00','\x02','\x0c','\x0c', // 0x00a0
    '\x02','\x08','\x18','\x18','\x02','\x38','\x28','\x38', // 0x00a8
    '\x59','\xd2','\xb5','\x2d','\x3b','\x76','\xe4','\x8c', // 0x00b0
    '\x18','\x10','\x30','\x60','\xc0','\xc0','\x03','\xfc', // 0x00b8
    '\xaf','\xb1','\x18','\x0c','\x06','\x03','\xc0','\x60', // 0x00c0
    '\x18','\x04','\x03','\x01','\x00','\x00','\x06','\xf8', // 0x00c8
    '\x1f','\x00','\x00','\x0e','\x80','\x40','\x20','\x10', // 0x00d0
    '\x00','\xc2','\x43','\xf0','\xfe','\x7f','\x01','\x00', // 0x00d8
    '\x00','\x0f','\xff','\x3e','\x00','\x00','\x03','\x03', // 0x00e0
    '\xff','\x1c','\x70','\xc0','\x00','\x00','\x1b','\xff', // 0x00e8
    '\xff','\x02','\x00','\x02','\x1f','\x33','\xe6','\x8c', // 0x00f0
    '\x08','\x98','\xd0','\x70','\x30','\x30','\x02','\x20', // 0x00f8
    '\x20','\x02','\x30','\x31','\x1f','\x1e','\x48','\xcc', // 0x0100
    '\x67','\x7c','\xfe','\xf6','\x6d','\x08','\x00','\x03', // 0x0108
    '\x04','\x18','\x60','\x80','\x80','\x02','\xfc','\x03', // 0x0110
    '\x00','\x00','\x06','\x80','\x80','\x02','\x60','\x30', // 0x0118
    '\x1c','\x07','\x01','\x00','\x20','\x30','\x32','\x3a', // 0x0120
    '\x1a','\x32','\x32','\x02','\xe2','\xe2','\x02','\x46', // 0x0128
    '\x06','\x02','\x03','\x80','\x80','\x03','\x40','\x20', // 0x0130
    '\x38','\x3e','\xdf','\xff','\x07','\x00','\x00','\x0a', // 0x0138
    '\x80','\xc0','\x60','\x60','\x02','\x38','\x3c','\x16', // 0x0140
    '\x09','\x04','\x06','\xc1','\x10','\x06','\x01','\x00', // 0x0148
    '\x00','\x02','\x01','\x07','\x1c','\xf0','\xc0','\x00', // 0x0150
    '\x00','\x17','\xff','\xff','\x02','\x00','\x00','\x04', // 0x0158
    '\xfc','\x87','\x01','\xce','\xee','\x24','\x22','\x20', // 0x0160
    '\x60','\x60','\x02','\x20','\xb0','\xb0','\x05','\xa0', // 0x0168
    '\xa0','\x02','\x20','\x60','\x40','\x40','\x02','\x60', // 0x0170
    '\x60','\x02','\x30','\x00','\x83','\xc7','\xfd','\xe3', // 0x0178
    '\xf6','\xe4','\xcc','\x8c','\x86','\x06','\x03','\x01', // 0x0180
    '\x00','\x00','\x02','\x0c','\x1c','\x3e','\x60','\xc0', // 0x0188
    '\xc0','\x02','\x40','\x40','\x06','\x20','\x19','\xef', // 0x0190
    '\x39','\x01','\x09','\x08','\x0c','\x0c','\x02','\x04', // 0x0198
    '\x06','\x03','\x00','\x1f','\x3f','\x60','\xc0','\x20', // 0x01a0
    '\x20','\x02','\x00','\x10','\x18','\x00','\x1c','\x1e', // 0x01a8
    '\x61','\xc1','\x80','\xc0','\xe0','\xe0','\x03','\x68', // 0x01b0
    '\x64','\xc6','\xc1','\x80','\x00','\x00','\x09','\x07', // 0x01b8
    '\x0e','\x38','\x60','\xc0','\x00','\x00','\x13','\xff', // 0x01c0
    '\xff','\x02','\x00','\x00','\x05','\x01','\x03','\x02', // 0x01c8
    '\x01','\x03','\x03','\x02','\x02','\x03','\x03','\x03', // 0x01d0
    '\x01','\x01','\x03','\x00','\x01','\x01','\x03','\x03', // 0x01d8
    '\x03','\x02','\x02','\x06','\x06','\x03','\x02','\x03', // 0x01e0
    '\x01','\x01','\x02','\xe0','\xff','\x1f','\x19','\x1b', // 0x01e8
    '\x1b','\x02','\x0f','\x87','\xce','\x74','\x1c','\x04', // 0x01f0
    '\x0c','\x88','\x8c','\xf8','\x7f','\x01','\x00','\x00', // 0x01f8
    '\x02','\x08','\x00','\x04','\x84','\xe0','\x3c','\x0f', // 0x0200
    '\x02','\x03','\x03','\x03','\x06','\x06','\x02','\x04', // 0x0208
    '\x0c','\x0c','\x06','\x0f','\x0e','\x38','\x60','\x80', // 0x0210
    '\x84','\x86','\x02','\x83','\x01','\x01','\x02','\x0f', // 0x0218
    '\xfe','\x87','\x07','\x07','\x03','\x0c','\x18','\x70', // 0x0220
    '\xc1','\x03','\x06','\x0c','\x18','\x30','\x60','\xc0', // 0x0228
    '\x80','\x00','\x00','\x05','\x01','\x03','\x04','\x08', // 0x0230
    '\x18','\x30','\x20','\x60','\x40','\xc0','\x80','\x80', // 0x0238
    '\x03','\x00','\x00','\x07','\xff','\xff','\x02','\x80', // 0x0240
    '\x80','\x17','\xa0','\xa0','\x02','\x90','\xb8','\xac', // 0x0248
    '\xbe','\xbe','\x02','\xa7','\xbf','\xb9','\xb3','\xb0', // 0x0250
    '\xb0','\x03','\xbc','\x96','\xbb','\x9e','\xbe','\xbe', // 0x0258
    '\x02','\xb6','\xb7','\xb3','\xb1','\xb0','\xb1','\xb2', // 0x0260
    '\xb4','\x94','\x9c','\x86','\x93','\x91','\x90','\x90', // 0x0268
    '\x0f','\xb8','\xbc','\xb4','\xb6','\xbb','\xb9','\xb5', // 0x0270
    '\xb1','\xb3','\x93','\x90','\x91','\x98','\x9c','\x93', // 0x0278
    '\x90','\x90','\x04','\x98','\x98','\x02','\x9f','\x91', // 0x0280
    '\x98','\x98','\x02','\x88','\x88','\x04','\x89','\x8b', // 0x0288
    '\x8a','\x82','\x86','\x84','\x8c','\x8c','\x02','\x88', // 0x0290
    '\x88','\x02','\x98','\x98','\x04','\x90','\x90','\x04', // 0x0298
    '\x91','\x91','\x03','\x93','\x93','\x03','\x92','\x92', // 0x02a0
    '\x02','\xff',
};

const unsigned char tian6[] PROGMEM = {
    '\x00','\x00','\x0d','\x07','\x1f','\x38','\x70','\xe0', // 0x0008
    '\xc0','\x80','\x80','\x02','\x04','\x06','\x07','\x87', // 0x0010
    '\x83','\xc3','\x67','\x36','\x36','\x02','\x1e','\x1e', // 0x0018
    '\x02','\x0c','\x8c','\x8e','\xc6','\xc6','\x02','\x66', // 0x0020
    '\x62','\x33','\x33','\x05','\x73','\x73','\x02','\x33', // 0x0028
    '\x13','\x02','\x06','\x04','\x02','\x97','\x9f','\x9e', // 0x0030
    '\x9e','\x04','\x3c','\x3c','\x02','\x78','\x71','\xe3', // 0x0038
    '\xc3','\x07','\x0e','\x0c','\x18','\x30','\xe0','\xf8', // 0x0040
    '\x7f','\x00','\x00','\x02','\xff','\x3f','\x18','\x18', // 0x0048
    '\x04','\x10','\x30','\x30','\x02','\x60','\xc0','\x80', // 0x0050
    '\x00','\x00','\x22','\x80','\x80','\x02','\xc0','\xc0', // 0x0058
    '\x02','\x60','\x30','\x1f','\x0f','\x00','\x00','\x13', // 0x0060
    '\x01','\x33','\x1b','\x1f','\x0f','\x0f','\x02','\x0d', // 0x0068
    '\x04','\xc6','\xf6','\x3e','\x0e','\x0e','\x02','\x87', // 0x0070
    '\xc3','\x61','\x30','\xf0','\xf0','\x02','\xf8','\x38', // 0x0078
    '\x38','\x02','\xec','\xcc','\x06','\x06','\x02','\x00', // 0x0080
    '\xe0','\x70','\x1c','\x06','\x03','\x03','\x02','\xe1', // 0x0088
    '\xf8','\x18','\x0c','\x0d','\x1d','\x7b','\xf7','\x0e', // 0x0090
    '\x78','\xe0','\x00','\x00','\x0a','\xff','\x07','\x00', // 0x0098
    '\x00','\x0a','\xff','\xbf','\x80','\x80','\x08','\xc0', // 0x00a0
    '\xc0','\x06','\x60','\x60','\x05','\x30','\x30','\x04', // 0x00a8
    '\x18','\x18','\x03','\x1c','\x0c','\x0c','\x02','\x06', // 0x00b0
    '\x06','\x02','\x07','\x03','\x03','\x02','\x01','\x01', // 0x00b8
    '\x02','\x00','\x00','\x1c','\x80','\xf0','\xfc','\x7f', // 0x00c0
    '\x39','\x1c','\x06','\x03','\x03','\x02','\x01','\x00', // 0x00c8
    '\x00','\x04','\xff','\xf8','\xfe','\xcf','\x83','\xff', // 0x00d0
    '\xfc','\x80','\x8f','\xff','\xc0','\x80','\x80','\x02', // 0x00d8
    '\xc0','\xc0','\x02','\xe7','\x6f','\x78','\x70','\x30', // 0x00e0
    '\x78','\x7e','\x6f','\x60','\x60','\x02','\x7f','\x40', // 0x00e8
    '\x40','\x03','\x60','\x60','\x03','\xf0','\xf0','\x02', // 0x00f0
    '\x38','\x1c','\x3f','\x60','\x60','\x02','\xb0','\xdc', // 0x00f8
    '\xfe','\x00','\x00','\x04','\xe0','\xff','\x1f','\x01', // 0x0100
    '\x01','\x09','\x00','\x00','\x03','\x80','\xc0','\xc0', // 0x0108
    '\x02','\x80','\x00','\x00','\x06','\xc0','\xc0','\x03', // 0x0110
    '\x80','\x00','\x00','\x24','\xc0','\xe0','\x60','\x63', // 0x0118
    '\x63','\x02','\xc0','\xc0','\x02','\x80','\x00','\x00', // 0x0120
    '\x08','\x38','\x78','\x4f','\xff','\xff','\x03','\x07', // 0x0128
    '\x03','\x03','\x02','\x01','\x01','\x07','\x61','\xf0', // 0x0130
    '\x98','\x0c','\xf6','\xf6','\x02','\xf3','\xf3','\x03', // 0x0138
    '\xe6','\xfe','\x3c','\x10','\x00','\x00','\x02','\x02', // 0x0140
    '\x03','\x33','\x3a','\x7e','\xfe','\xee','\x64','\x60', // 0x0148
    '\xfd','\xff','\x7f','\x7f','\x02','\x43','\x03','\x06', // 0x0150
    '\x0f','\x1c','\x70','\xe0','\x80','\x00','\x00','\x04', // 0x0158
    '\x80','\xc0','\xc0','\x02','\x40','\xf0','\xff','\x03', // 0x0160
    '\x00','\x01','\x3f','\xfe','\xe0','\xe0','\x02','\x3c', // 0x0168
    '\x06','\x03','\x01','\x00','\x00','\x02','\xf7','\xff', // 0x0170
    '\x00','\x00','\x02','\x80','\xe0','\x30','\x30','\x03', // 0x0178
    '\xe0','\x00','\x00','\x0e','\x30','\xfc','\x8c','\x06', // 0x0180
    '\x02','\x02','\x02','\x06','\x0c','\x18','\x70','\xe0', // 0x0188
    '\x80','\x00','\x0f','\x7f','\xc0','\x00','\x00','\x04', // 0x0190
    '\x03','\x1f','\xf8','\xe0','\x60','\x20','\x20','\x02', // 0x0198
    '\x60','\x60','\x04','\x40','\xc0','\xc1','\x83','\x03', // 0x01a0
    '\x06','\x0c','\x1c','\x18','\x30','\x30','\x02','\x60', // 0x01a8
    '\xe0','\xc0','\xc0','\x02','\xc1','\xc3','\xc7','\xdf', // 0x01b0
    '\xf9','\xf1','\xf8','\xef','\xe7','\x70','\x30','\xf8', // 0x01b8
    '\xf8','\x02','\xcc','\xce','\xe7','\xf3','\x33','\x01', // 0x01c0
    '\x23','\x63','\x67','\x66','\x66','\x02','\x46','\xc6', // 0x01c8
    '\xc6','\x02','\x84','\x84','\x02','\x8c','\x8c','\x02', // 0x01d0
    '\x0c','\x8c','\x0f','\xdf','\xf8','\x3c','\x16','\x03', // 0x01d8
    '\x01','\x00','\x00','\x02','\x80','\xff','\x1f','\x00', // 0x01e0
    '\x00','\x02','\xc0','\xfc','\xff','\x3f','\x01','\x00', // 0x01e8
    '\x00','\x03','\x80','\xe0','\xfc','\xff','\x7e','\x3c', // 0x01f0
    '\x07','\x03','\x00','\xc0','\x70','\x3c','\x0f','\x00', // 0x01f8
    '\x00','\x08','\x80','\xc0','\x60','\x60','\x03','\xc0', // 0x0200
    '\xc0','\x02','\x81','\x87','\x8e','\x1c','\x38','\x70', // 0x0208
    '\x60','\xc0','\xc0','\x03','\x03','\x0f','\x3c','\x3c', // 0x0210
    '\x02','\x1f','\x1f','\x02','\x1e','\x18','\x30','\x10', // 0x0218
    '\x00','\x00','\x02','\x0f','\x1e','\x3c','\x66','\x6c', // 0x0220
    '\xcc','\x98','\x70','\xc0','\x00','\x00','\x02','\x01', // 0x0228
    '\x03','\x06','\x3c','\xf8','\xf0','\x98','\x9e','\x8f', // 0x0230
    '\xcf','\xcf','\x03','\x7c','\x78','\x71','\x21','\x60', // 0x0238
    '\x60','\x02','\x40','\xc0','\xc0','\x03','\x80','\x81', // 0x0240
    '\x81','\x02','\x80','\x80','\x02','\x83','\x86','\x8c', // 0x0248
    '\x88','\x98','\x98','\x04','\x90','\xf0','\xf0','\x02', // 0x0250
    '\xfc','\x3c','\x00','\x01','\x01','\x03','\xff','\xff', // 0x0258
    '\x03','\x00','\x00','\x03','\xf0','\xfc','\x8e','\xf3', // 0x0260
    '\x3f','\x0f','\x00','\x00','\x02','\x06','\x07','\x03', // 0x0268
    '\x01','\x00','\x00','\x05','\x03','\x00','\x01','\x01', // 0x0270
    '\x02','\x00','\x00','\x02','\x18','\x1e','\x1f','\x09', // 0x0278
    '\x04','\x86','\x82','\xc3','\xc3','\x02','\x7f','\x1c', // 0x0280
    '\x00','\x00','\x04','\x03','\x0e','\x18','\x30','\x30', // 0x0288
    '\x02','\x20','\x60','\xe0','\xe1','\xe1','\x02','\xe3', // 0x0290
    '\xe3','\x03','\xe2','\xe7','\xe3','\x00','\x00','\x07', // 0x0298
    '\xe0','\xc0','\xc0','\x02','\x80','\x80','\x02','\x00', // 0x02a0
    '\x00','\x05','\x80','\xc8','\x0f','\x0e','\x1f','\x1f', // 0x02a8
    '\x02','\x30','\x30','\x04','\x70','\xff','\x0f','\x01', // 0x02b0
    '\x01','\x02','\x00','\x00','\x07','\x80','\xc0','\xe0', // 0x02b8
    '\xe0','\x03','\xc0','\xfc','\xff','\x81','\x01','\x01', // 0x02c0
    '\x02','\x81','\xff','\x07','\x01','\x01','\x02','\x81', // 0x02c8
    '\x81','\x02','\xe1','\xf0','\xf0','\x02','\x98','\x1f', // 0x02d0
    '\x1f','\x02','\x08','\x18','\x18','\x02','\x30','\x3e', // 0x02d8
    '\xff','\xe0','\x43','\x6f','\x7c','\x70','\x67','\x3f', // 0x02e0
    '\x1f','\x0c','\x00','\x00','\x02','\x80','\xc0','\xc0', // 0x02e8
    '\x03','\xe0','\xe0','\x02','\xd0','\xd8','\xce','\x6f', // 0x02f0
    '\x38','\x18','\x18','\x02','\x10','\x18','\x18','\x03', // 0x02f8
    '\x0e','\x06','\x03','\x03','\x02','\x01','\x01','\x03', // 0x0300
    '\x00','\x00','\x0b','\x1e','\x3e','\x33','\x61','\x61', // 0x0308
    '\x06','\x20','\x20','\x02','\x30','\x18','\x18','\x02', // 0x0310
    '\x0c','\x06','\x06','\x04','\x02','\x07','\x0f','\x0f', // 0x0318
    '\x02','\x1b','\x1b','\x03','\x13','\x13','\x05','\x1b', // 0x0320
    '\x1f','\x0f','\x06','\x0e','\x0c','\x0c','\x03','\x0e', // 0x0328
    '\x0f','\x0f','\x02','\x1f','\x3e','\xec','\xcc','\x1c', // 0x0330
    '\x18','\x38','\x70','\xe0','\xfe','\x1f','\x01','\x00', // 0x0338
    '\x00','\x03','\x01','\x03','\x03','\x02','\x0f','\x1f', // 0x0340
    '\x3b','\xe7','\xc7','\x0e','\x0f','\x19','\x19','\x02', // 0x0348
    '\x39','\x30','\xf0','\xe0','\xc0','\x80','\x80','\x02', // 0x0350
    '\x00','\x00','\x04','\x0f','\x1f','\x30','\x20','\xe0', // 0x0358
    '\xe0','\x02','\x20','\x30','\x18','\x0c','\x06','\x02', // 0x0360
    '\x01','\x01','\x02','\x00','\x00','\x1e',
};

const unsigned char tian7[] PROGMEM = {
    '\x00','\x00','\x06','\x80','\x40','\x80','\x50','\xa8', // 0x0008
    '\xf1','\xe0','\xc1','\x80','\xc0','\x80','\xc0','\x80', // 0x0010
    '\x00','\x0a','\x10','\x28','\x74','\xb8','\x5d','\xf8', // 0x0018
    '\xf0','\xf8','\x50','\x2e','\xd5','\x3e','\x7c','\x20', // 0x0020
    '\x50','\xe8','\x40','\x80','\x00','\x00','\x5b','\x80', // 0x0028
    '\xc0','\xa0','\xc5','\xae','\xdc','\xb0','\xe7','\xef', // 0x0030
    '\xff','\xff','\x06','\xd7','\xaf','\x5f','\xbc','\x58', // 0x0038
    '\xf8','\xd0','\xe0','\x10','\xe9','\xf3','\xa2','\x45', // 0x0040
    '\x02','\x01','\x80','\xc0','\xe8','\xf5','\x7e','\x7f', // 0x0048
    '\x81','\xc0','\xa0','\x00','\x00','\x5a','\x1d','\x0f', // 0x0050
    '\x07','\x0a','\x1d','\xbf','\x7f','\xbf','\x5f','\xaf', // 0x0058
    '\xd7','\xeb','\x57','\x8b','\x57','\xa2','\x11','\x2e', // 0x0060
    '\x5f','\x2e','\x07','\xa3','\x45','\xab','\x51','\xaa', // 0x0068
    '\x44','\xa0','\x15','\x0f','\x07','\x03','\x05','\x06', // 0x0070
    '\x11','\x03','\x05','\x00','\x00','\x5a','\x2c','\x5c', // 0x0078
    '\x7e','\x5c','\x2c','\x04','\x8e','\x1f','\x3f','\x7f', // 0x0080
    '\x7f','\x02','\x7d','\xf8','\x7c','\xf8','\xf5','\xf2', // 0x0088
    '\xf5','\xfa','\xf3','\xfe','\x55','\x60','\xf5','\xe0', // 0x0090
    '\xf1','\xf8','\x30','\x60','\x50','\x60','\x74','\x3a', // 0x0098
    '\x7c','\x3e','\xf4','\xf8','\x00','\x00','\x59','\xe0', // 0x00a0
    '\xf4','\xfe','\xfd','\xfe','\xfc','\xfe','\x7c','\xab', // 0x00a8
    '\x55','\xf8','\xf0','\xf0','\x02','\x70','\x30','\x10', // 0x00b0
    '\x00','\x41','\x21','\xc1','\x81','\xf5','\xbb','\xc0', // 0x00b8
    '\x80','\xc0','\x01','\x01','\x02','\x00','\x00','\x02', // 0x00c0
    '\x80','\xc0','\xe0','\x70','\x08','\x11','\xa0','\x01', // 0x00c8
    '\x80','\x00','\x00','\x0b','\x80','\xc0','\xc0','\x03', // 0x00d0
    '\x60','\x70','\xe0','\x70','\xe0','\xf0','\xe0','\xe0', // 0x00d8
    '\x03','\xc0','\xc0','\x03','\x80','\xc0','\x80','\xc0', // 0x00e0
    '\xe0','\xe0','\x03','\xf0','\xb8','\xdc','\x6c','\x74', // 0x00e8
    '\x72','\x72','\x02','\x7a','\x70','\x7a','\x7c','\x28', // 0x00f0
    '\x0c','\x08','\x00','\x00','\x29','\xfb','\x5f','\x2f', // 0x00f8
    '\xdf','\xaf','\x57','\xaf','\x55','\x0a','\x1d','\xbb', // 0x0100
    '\x77','\xef','\xd9','\xb0','\x70','\xf8','\xdc','\xfc', // 0x0108
    '\x4c','\x69','\x6f','\x6f','\x03','\x4b','\x41','\x98', // 0x0110
    '\xdc','\xb8','\xc0','\xa2','\xd7','\xfb','\xfd','\xfe', // 0x0118
    '\xff','\xff','\x02','\xfd','\xe0','\x40','\x00','\x00', // 0x0120
    '\x02','\x80','\x00','\xa0','\x40','\x00','\x40','\x2b', // 0x0128
    '\x05','\x03','\x01','\x00','\x00','\x07','\x01','\x01', // 0x0130
    '\x03','\x83','\x03','\x83','\x87','\x83','\x07','\x03', // 0x0138
    '\x07','\x03','\x03','\x02','\x01','\x01','\x02','\x00', // 0x0140
    '\x00','\x36','\xf0','\x79','\xfa','\xff','\xbf','\xf1', // 0x0148
    '\xe2','\xd5','\xea','\x5e','\xfe','\xfd','\xfa','\xf5', // 0x0150
    '\xfe','\xd4','\xeb','\xfd','\xb8','\x70','\x78','\x54', // 0x0158
    '\xe0','\xf0','\xe8','\xf0','\xfe','\x7d','\x2f','\x1f', // 0x0160
    '\x0f','\x0f','\x02','\xbf','\x7f','\xcf','\xc3','\x82', // 0x0168
    '\x01','\x83','\x07','\x02','\x06','\x82','\x04','\x0c', // 0x0170
    '\x0c','\x02','\x08','\x18','\x08','\x10','\x00','\x00', // 0x0178
    '\x03','\x04','\x08','\x04','\x00','\x00','\x02','\x02', // 0x0180
    '\x00','\x02','\x01','\x00','\x01','\x06','\x05','\x05', // 0x0188
    '\x03','\x0b','\x0d','\x0a','\x13','\x22','\xc4','\xa2', // 0x0190
    '\xe4','\xe0','\xc0','\x88','\x50','\x00','\x00','\x30', // 0x0198
    '\x8a','\xdd','\x9a','\xdd','\x9b','\x17','\x3f','\x7d', // 0x01a0
    '\xfe','\xff','\xbe','\x3f','\x3f','\x04','\x7f','\x7f', // 0x01a8
    '\x03','\xfa','\x71','\xa2','\xc0','\xfe','\xff','\xff', // 0x01b0
    '\x02','\xd1','\xa0','\xfc','\xfe','\xf9','\xe0','\xe0', // 0x01b8
    '\x03','\xc1','\x82','\x10','\x82','\x85','\x83','\xde', // 0x01c0
    '\xec','\x5c','\x88','\x50','\xa0','\x60','\x20','\x00', // 0x01c8
    '\x22','\x00','\x20','\x00','\x20','\x00','\x20','\x40', // 0x01d0
    '\x80','\x00','\x00','\x11','\x01','\x03','\x03','\x02', // 0x01d8
    '\x07','\x0f','\x1f','\x08','\x10','\x20','\x40','\x00', // 0x01e0
    '\x00','\x2c',
};

const unsigned char tian8[] PROGMEM = {
    '\x3e','\x0a','\x04','\x00','\x00','\x05','\x3e','\x00', // 0x0008
    '\x3e','\x00','\x3e','\x00','\x3e','\x00','\x3e','\x00', // 0x0010
    '\x3e','\x00','\x3e','\x00','\x3e','\x00','\x00','\x91', // 0x0018
    '\x08','\x2a','\x1c','\x7f','\x1c','\x2a','\x08','\x00', // 0x0020
    '\x00','\x82','\x80','\x80','\x02','\x40','\x40','\x02', // 0x0028
    '\xe0','\x18','\xfc','\x7e','\x3e','\x3e','\x02','\xbd', // 0x0030
    '\xb9','\x6a','\xec','\x38','\xf0','\x00','\x00','\x16', // 0x0038
    '\x80','\xe0','\x70','\x30','\x18','\x18','\x04','\x30', // 0x0040
    '\x70','\xe0','\x80','\xc0','\xe0','\xe0','\x02','\x60', // 0x0048
    '\xa0','\xa0','\x02','\xe0','\xc0','\x80','\x80','\x02', // 0x0050
    '\x00','\x00','\x42','\x0e','\x1f','\x3c','\x7c','\xf8', // 0x0058
    '\xfc','\xf8','\xb3','\x07','\x0c','\x10','\x14','\x15', // 0x0060
    '\x95','\x54','\x29','\x24','\x27','\x22','\x22','\x03', // 0x0068
    '\x1e','\x3f','\x3b','\x3b','\x03','\x1e','\x1a','\x0c', // 0x0070
    '\x00','\x00','\x07','\x80','\x40','\x40','\x03','\x47', // 0x0078
    '\x5f','\x78','\x70','\x60','\x60','\x04','\x70','\xf8', // 0x0080
    '\xff','\xf7','\xe0','\x6c','\xad','\x93','\x93','\x02', // 0x0088
    '\xad','\x6c','\xe0','\xf3','\xff','\xff','\x03','\x81', // 0x0090
    '\x81','\x02','\xff','\xff','\x02','\x81','\x81','\x06', // 0x0098
    '\xff','\xff','\x02','\x81','\x81','\x05','\x00','\x00', // 0x00a0
    '\x2c','\xc0','\xe0','\xe0','\x02','\xf0','\xf0','\x02', // 0x00a8
    '\xf8','\xfc','\xf2','\xe1','\x23','\x17','\x0f','\xcf', // 0x00b0
    '\xf7','\xf3','\xf1','\xfb','\xfc','\xf8','\xe0','\xc0', // 0x00b8
    '\x00','\x00','\x11','\x07','\x68','\x08','\x9b','\xfa', // 0x00c0
    '\xf8','\xf8','\x06','\xfa','\xfb','\xf8','\xf8','\x02', // 0x00c8
    '\x07','\x0f','\x1f','\x1e','\x1e','\x04','\x0e','\x1e', // 0x00d0
    '\x1f','\x0f','\x07','\x03','\x07','\x00','\x00','\x29', // 0x00d8
    '\xff','\x81','\x99','\xbd','\xe7','\xbd','\x81','\xff', // 0x00e0
    '\x81','\xff','\xff','\x02','\x81','\x81','\x06','\xff', // 0x00e8
    '\xff','\x02','\x81','\x81','\x06','\xff','\xff','\x02', // 0x00f0
    '\x81','\x81','\x06','\xff','\xff','\x02','\x81','\x81', // 0x00f8
    '\x06','\xff','\xff','\x02','\x81','\x81','\x05','\xff', // 0x0100
    '\x81','\xbd','\xe7','\xbd','\x99','\x81','\xff','\x00', // 0x0108
    '\x00','\x02','\x0e','\x11','\x21','\x2d','\x25','\x21', // 0x0110
    '\x21','\x06','\x25','\x2d','\x21','\x11','\x0e','\x00', // 0x0118
    '\x00','\x9e','\x6b','\x7b','\x7b','\x02','\x5b','\x6b', // 0x0120
    '\x7b','\x7b','\x02','\x5b','\x6b','\x7b','\x7b','\x03', // 0x0128
    '\x03','\x03','\x02','\xff','\xff','\x02','\x00','\x00', // 0x0130
    '\x50','\x08','\x2a','\x1c','\x7f','\x1c','\x2a','\x08', // 0x0138
    '\x00','\x08','\x2a','\x1c','\x7f','\x1c','\x2a','\x08', // 0x0140
    '\x00','\x08','\x2a','\x1c','\x7f','\x1c','\x2a','\x08', // 0x0148
    '\x00','\x08','\x2a','\x1c','\x7f','\x1c','\x2a','\x08', // 0x0150
    '\x00','\x00',
};

const unsigned char tian9[] PROGMEM = {
    '\x00','\x00','\x15','\x80','\x00','\x00','\x04','\x87', // 0x0008
    '\x0e','\x1e','\x1e','\x02','\x0e','\x87','\x00','\x00', // 0x0010
    '\x04','\x87','\x0e','\x1e','\x1e','\x02','\x0e','\x87', // 0x0018
    '\x00','\x00','\x04','\x87','\x0e','\x1e','\x1e','\x02', // 0x0020
    '\x0e','\x87','\x00','\x00','\x04','\x87','\x0e','\x1e', // 0x0028
    '\x1e','\x02','\x0e','\x87','\x00','\x00','\x04','\x87', // 0x0030
    '\x0e','\x1e','\x1e','\x02','\x0e','\x07','\x00','\x00', // 0x0038
    '\x19','\x7f','\x40','\x40','\x04','\x00','\x00','\x02', // 0x0040
    '\x41','\x7f','\x41','\x00','\x00','\x02','\x1f','\x20', // 0x0048
    '\x40','\x20','\x1f','\x00','\x7f','\x49','\x49','\x03', // 0x0050
    '\x41','\x00','\x46','\x49','\x49','\x03','\x31','\x00', // 0x0058
    '\x00','\x17','\x07','\x0e','\x1e','\x1e','\x02','\x0e', // 0x0060
    '\x87','\x00','\x00','\x04','\x87','\x0e','\x1e','\x1e', // 0x0068
    '\x02','\x0e','\x87','\x00','\x00','\x04','\x87','\x0e', // 0x0070
    '\x1e','\x1e','\x02','\x0e','\x87','\x00','\x00','\x04', // 0x0078
    '\x87','\x0e','\x1e','\x1e','\x02','\x0e','\x87','\x00', // 0x0080
    '\x00','\x04','\x87','\x0e','\x1e','\x1e','\x02','\x0e', // 0x0088
    '\x87','\x00','\x00','\x04','\x80','\x00','\x00','\x31', // 0x0090
    '\x21','\x41','\x45','\x4b','\x31','\x00','\x00','\x17', // 0x0098
    '\x80','\x00','\x00','\x04','\x87','\x0e','\x1e','\x1e', // 0x00a0
    '\x02','\x0e','\x07','\x00','\xf0','\xc0','\xc0','\x02', // 0x00a8
    '\xc7','\xce','\xfe','\x9e','\x0e','\x07','\x80','\x80', // 0x00b0
    '\x02','\x00','\x00','\x02','\x87','\x0e','\x1e','\x1e', // 0x00b8
    '\x02','\x0e','\x07','\x00','\x00','\x04','\x07','\x0e', // 0x00c0
    '\x9e','\xde','\x8e','\x87','\x00','\x00','\x04','\x87', // 0x00c8
    '\x0e','\x1e','\x1e','\x02','\x0e','\x07','\x00','\x00', // 0x00d0
    '\x4d','\x07','\x0e','\x1e','\x1e','\x02','\x0e','\x07', // 0x00d8
    '\x00','\x00','\x07','\x01','\x03','\x13','\x15','\x0a', // 0x00e0
    '\x1a','\x19','\x0f','\x1b','\x16','\x00','\x02','\x17', // 0x00e8
    '\x02','\x08','\x00','\x00','\x0a','\x01','\x00','\x07', // 0x00f0
    '\x0e','\x1e','\x1e','\x02','\x0e','\x07','\x00','\x00', // 0x00f8
    '\x1e','\x7f','\x40','\x40','\x04','\x00','\x7f','\x49', // 0x0100
    '\x49','\x03','\x41','\x00','\x1f','\x20','\x40','\x20', // 0x0108
    '\x1f','\x00','\x7f','\x49','\x49','\x03','\x41','\x00', // 0x0110
    '\x7f','\x40','\x40','\x04','\x00','\x00','\x22','\x1e', // 0x0118
    '\x1f','\x1e','\x00','\x00','\x0f','\x40','\xe0','\x40', // 0x0120
    '\x00','\x00','\x45','\x42','\x7f','\x40','\x00','\x00', // 0x0128
    '\x1c','\x80','\xc0','\x80','\x1e','\x1f','\x1e','\x00', // 0x0130
    '\x00','\x7a','\x07','\x07','\x03','\x00','\x00','\x03', // 0x0138
    '\x20','\x78','\x3c','\x08','\x00','\x00','\x10','\x20', // 0x0140
    '\x70','\x20','\x00','\x00','\x2b','\x46','\x49','\x49', // 0x0148
    '\x03','\x31','\x00','\x3e','\x41','\x41','\x03','\x22', // 0x0150
    '\x00','\x3e','\x41','\x41','\x03','\x3e','\x00','\x7f', // 0x0158
    '\x09','\x19','\x29','\x46','\x00','\x7f','\x49','\x49', // 0x0160
    '\x03','\x41','\x00','\x00','\x17','\x7c','\x60','\x7e', // 0x0168
    '\x7f','\x7e','\x60','\x7c','\x00','\x00','\x12','\x20', // 0x0170
    '\x70','\x20','\x00','\x00','\x3c','\x21','\x41','\x45', // 0x0178
    '\x4b','\x31','\x00','\x00','\x02','\x42','\x7f','\x40', // 0x0180
    '\x00','\x00','\x02','\x06','\x49','\x49','\x02','\x29', // 0x0188
    '\x1e','\x00','\x00','\x02',
};

const unsigned char tian10[] PROGMEM = {
    '\x00','\x00','\xff','\x00','\x00','\x43','\xf8','\x48', // 0x0008
    '\x08','\x48','\x18','\xf0','\x40','\x20','\xff','\x01', // 0x0010
    '\x55','\x01','\xff','\x00','\x00','\x02','\xc0','\x00', // 0x0018
    '\x40','\x40','\x02','\x7c','\x7c','\x03','\x78','\x78', // 0x0020
    '\x02','\x40','\xfe','\x02','\x56','\x02','\x56','\x02', // 0x0028
    '\x5e','\x08','\xf8','\x40','\x40','\x02','\xff','\xab', // 0x0030
    '\x56','\xfe','\x00','\x00','\x16','\x08','\x28','\x08', // 0x0038
    '\x08','\x03','\x48','\x08','\x08','\x06','\x18','\x08', // 0x0040
    '\x08','\x09','\x98','\x88','\x08','\x08','\x06','\x18', // 0x0048
    '\x08','\x08','\x07','\x58','\x08','\x08','\x08','\x18', // 0x0050
    '\x08','\x08','\x03','\x28','\x08','\x08','\x08','\x18', // 0x0058
    '\x88','\x88','\x03','\xc8','\xc8','\x02','\xcf','\x6d', // 0x0060
    '\x68','\x2d','\xa8','\xbf','\xd8','\x38','\xbf','\xd8', // 0x0068
    '\x7d','\x08','\x1f','\x09','\x09','\x02','\x0f','\x08', // 0x0070
    '\x08','\x02','\x0d','\x08','\x0d','\x08','\x8d','\x18', // 0x0078
    '\x28','\x0f','\x08','\x0d','\x28','\x0d','\x08','\x0d', // 0x0080
    '\x08','\x0f','\x08','\x08','\x02','\x0f','\x0a','\x0d', // 0x0088
    '\x2f','\x08','\x28','\x28','\x02','\x08','\xb8','\xa8', // 0x0090
    '\x28','\x08','\x28','\x08','\x08','\x04','\x28','\x18', // 0x0098
    '\x08','\x08','\x06','\x18','\x08','\x00','\x00','\x05', // 0x00a0
    '\x04','\x00','\x00','\x08','\x38','\x00','\x00','\x03', // 0x00a8
    '\x80','\x00','\x00','\x09','\x08','\x00','\x00','\x06', // 0x00b0
    '\x80','\x80','\x02','\xc0','\xc0','\x02','\xc8','\xe0', // 0x00b8
    '\xe0','\x03','\xf0','\xf0','\x02','\x70','\x68','\x28', // 0x00c0
    '\x28','\x03','\x14','\x14','\x02','\x0c','\x0e','\x0e', // 0x00c8
    '\x02','\x06','\x07','\x03','\x03','\x03','\x81','\x81', // 0x00d0
    '\x03','\x90','\x18','\x18','\x02','\x0c','\x04','\x01', // 0x00d8
    '\x01','\x03','\x00','\xfe','\x3f','\xff','\x00','\x00', // 0x00e0
    '\x10','\x01','\x00','\x00','\x08','\x80','\x00','\x00', // 0x00e8
    '\x04','\x10','\x00','\x00','\x0a','\x80','\x00','\x00', // 0x00f0
    '\x05','\x01','\x00','\x00','\x06','\x10','\x00','\x00', // 0x00f8
    '\x04','\x40','\x00','\x00','\x05','\x08','\x00','\x00', // 0x0100
    '\x03','\x80','\x80','\x03','\x40','\x40','\x02','\x20', // 0x0108
    '\x20','\x02','\x10','\x10','\x03','\x18','\x18','\x02', // 0x0110
    '\x9c','\xdc','\x5e','\x3e','\x3e','\x02','\x9f','\x9f', // 0x0118
    '\x02','\x8f','\x0f','\x07','\x87','\x83','\x81','\xc1', // 0x0120
    '\xc0','\xc0','\x03','\x80','\x80','\x03','\x00','\x00', // 0x0128
    '\x02','\x80','\x80','\x03','\x00','\x10','\x18','\x1c', // 0x0130
    '\x16','\x13','\x11','\x10','\x1c','\x03','\x00','\x00', // 0x0138
    '\x09','\x01','\x07','\x08','\x11','\x31','\x72','\x74', // 0x0140
    '\xfc','\xf8','\xf0','\xe0','\xe0','\x03','\xc0','\xc0', // 0x0148
    '\x03','\x82','\x80','\x80','\x02','\x00','\x00','\x0e', // 0x0150
    '\x20','\x00','\x00','\x0b','\x40','\x00','\x00','\x04', // 0x0158
    '\x02','\x00','\x00','\x04','\x80','\xc0','\xc0','\x02', // 0x0160
    '\xe0','\xe0','\x03','\xf0','\xf8','\xf8','\x03','\xfc', // 0x0168
    '\xfc','\x03','\xfa','\xfa','\x02','\xf9','\x79','\x78', // 0x0170
    '\x38','\x38','\x02','\x18','\x18','\x02','\x08','\x04', // 0x0178
    '\x04','\x02','\x02','\x02','\x02','\x01','\xc1','\xe0', // 0x0180
    '\xe0','\x04','\x23','\xe7','\x07','\xf4','\xbb','\xaa', // 0x0188
    '\xaa','\x03','\xa6','\xa9','\xa4','\xa4','\x02','\xa9', // 0x0190
    '\xa6','\xaa','\xaa','\x02','\xea','\xfb','\xf4','\x27', // 0x0198
    '\xe7','\x23','\xe0','\xe0','\x05','\x20','\x20','\x03', // 0x01a0
    '\xc0','\x00','\x00','\x12','\x01','\x01','\x03','\x03', // 0x01a8
    '\x03','\x03','\x07','\x07','\x03','\x0f','\x0f','\x03', // 0x01b0
    '\x1f','\x1e','\x1e','\x02','\x3e','\x3e','\x02','\x7c', // 0x01b8
    '\x5c','\x5c','\x02','\x98','\x98','\x03','\x10','\x10', // 0x01c0
    '\x03','\x20','\x20','\x03','\x40','\x40','\x04','\x80', // 0x01c8
    '\x80','\x03','\x00','\x00','\x05','\x04','\x00','\x00', // 0x01d0
    '\x04','\x0f','\x0f','\x02','\x4f','\x4f','\x02','\x2f', // 0x01d8
    '\x1f','\x1f','\x02','\x0f','\x0f','\x02','\x07','\x07', // 0x01e0
    '\x02','\x03','\x03','\x02','\x01','\x00','\x00','\x0e', // 0x01e8
    '\x07','\x07','\x05','\x04','\x03','\x01','\x01','\x04', // 0x01f0
    '\x03','\x02','\x02','\x05','\x42','\x32','\x0e','\x03', // 0x01f8
    '\x01','\x01','\x04','\x03','\x04','\x07','\x07','\x05', // 0x0200
    '\x00','\x00','\x03','\x03','\x3c','\x40','\x00','\x00', // 0x0208
    '\x27','\x01','\x01','\x03','\x02','\x02','\x03','\x04', // 0x0210
    '\x04','\x03','\x0c','\x0c','\x03','\x1c','\x1d','\x1d', // 0x0218
    '\x02','\x3d','\x3e','\x3e','\x02','\x7e','\x7c','\x7c', // 0x0220
    '\x04',
};

const unsigned char tian11[] PROGMEM = {
    '\x00','\x00','\x1f','\xc0','\xb0','\xf8','\x38','\x1c', // 0x0008
    '\x04','\x02','\x82','\xc1','\x41','\x21','\x21','\x03', // 0x0010
    '\x41','\xc2','\x04','\x08','\x70','\xc0','\x00','\x00', // 0x0018
    '\x6b','\xf8','\x7f','\x1f','\x07','\x00','\x00','\x03', // 0x0020
    '\x3c','\xc7','\x01','\x00','\x00','\x07','\x07','\x06', // 0x0028
    '\x1c','\x1f','\x3c','\x00','\x00','\x14','\x80','\xc0', // 0x0030
    '\x40','\x60','\x20','\x20','\x04','\x40','\x40','\x02', // 0x0038
    '\x80','\x80','\x02','\x40','\x40','\x08','\xc0','\x00', // 0x0040
    '\x00','\x41','\x03','\x1e','\x20','\xc0','\x80','\x00', // 0x0048
    '\x00','\x03','\x01','\x06','\x18','\x30','\x20','\x60', // 0x0050
    '\xc0','\xc0','\x03','\x80','\x80','\x07','\x00','\x00', // 0x0058
    '\x10','\xc0','\xf0','\xdf','\x40','\x40','\x05','\xf0', // 0x0060
    '\xf8','\xb8','\xe8','\x18','\x18','\x02','\x08','\x08', // 0x0068
    '\x03','\x0c','\x04','\x06','\x02','\x01','\x01','\x02', // 0x0070
    '\x00','\x00','\x40','\xc0','\x70','\x0c','\x03','\x01', // 0x0078
    '\x00','\x00','\x11','\x01','\x01','\x02','\x03','\x03', // 0x0080
    '\x02','\x01','\x01','\x02','\x03','\x03','\x03','\x07', // 0x0088
    '\x86','\x66','\xb4','\xec','\x18','\x0c','\x0a','\x03', // 0x0090
    '\x03','\x02','\x0d','\x01','\x00','\x00','\x0a','\x01', // 0x0098
    '\x02','\x64','\xb8','\xf0','\xc0','\x00','\x00','\x44', // 0x00a0
    '\xfe','\x93','\x00','\x00','\x09','\xc0','\x30','\xd2', // 0x00a8
    '\xec','\x30','\x00','\x00','\x11','\xe2','\x1f','\x05', // 0x00b0
    '\x07','\x00','\x00','\x05','\xc0','\x60','\x10','\x00', // 0x00b8
    '\x00','\x04','\x30','\xd8','\xe4','\xf4','\xe8','\x78', // 0x00c0
    '\x00','\x18','\x0d','\x02','\x01','\x01','\x02','\x79', // 0x00c8
    '\x79','\x02','\x19','\xc2','\x7d','\x41','\x45','\x4d', // 0x00d0
    '\x55','\x7e','\x00','\x00','\x39','\x83','\xdf','\x62', // 0x00d8
    '\x00','\x00','\x05','\x84','\xf1','\x60','\x3c','\x2e', // 0x00e0
    '\x67','\xf1','\xf0','\xa0','\xc0','\x40','\x00','\x00', // 0x00e8
    '\x06','\xfc','\xf0','\x80','\x00','\x00','\x05','\xff', // 0x00f0
    '\xf1','\x40','\x00','\x00','\x05','\x90','\xef','\xf8', // 0x00f8
    '\x00','\x00','\x04','\x80','\x80','\x03','\xc0','\x40', // 0x0100
    '\x60','\x20','\x20','\x03','\x2c','\x48','\x50','\x50', // 0x0108
    '\x03','\x38','\x2e','\x1b','\x07','\x00','\x00','\x3d', // 0x0110
    '\x07','\x08','\xf0','\x00','\x00','\x03','\x01','\x0f', // 0x0118
    '\x13','\x01','\xa0','\x00','\xc0','\x00','\x00','\x04', // 0x0120
    '\x01','\x01','\x02','\x03','\x03','\x02','\x06','\x06', // 0x0128
    '\x02','\x04','\x04','\x04','\x07','\x0f','\x10','\x20', // 0x0130
    '\x78','\xc0','\x80','\x03','\x05','\x0a','\x1a','\x30', // 0x0138
    '\x60','\xc0','\x32','\x09','\x0f','\x09','\x11','\x21', // 0x0140
    '\x61','\xc1','\x80','\x80','\x03','\x00','\x00','\x4e', // 0x0148
    '\x03','\x06','\x04','\x08','\x06','\x08','\x0d','\x06', // 0x0150
    '\x03','\x01','\x00','\x00','\x15','\x01','\x03','\x02', // 0x0158
    '\x06','\x04','\x04','\x02','\x08','\x08','\x03','\x10', // 0x0160
    '\x10','\x03','\x30','\x20','\x60','\x40','\x80','\x80', // 0x0168
    '\x03','\x89','\x95','\xe5','\xca','\x3e','\x08','\x00', // 0x0170
    '\x00','\x2c',
};

const unsigned char tian12[] PROGMEM = {
    '\x00','\x00','\x34','\x80','\x00','\x00','\x04','\xfe', // 0x0008
    '\x0c','\x18','\x30','\x60','\xc0','\x80','\x00','\x00', // 0x0010
    '\x67','\x80','\x80','\x04','\x40','\x40','\x06','\x60', // 0x0018
    '\x60','\x03','\xff','\xf3','\x82','\x06','\x2c','\x4f', // 0x0020
    '\x5c','\x98','\xb0','\x70','\x60','\xc1','\x87','\x8c', // 0x0028
    '\x18','\x30','\x60','\xc0','\x80','\x00','\x00','\x59', // 0x0030
    '\xc0','\x60','\x18','\x0c','\x06','\x02','\x03','\x01', // 0x0038
    '\x00','\x00','\x0d','\x07','\x3f','\xf8','\xc0','\x80', // 0x0040
    '\x20','\x40','\x81','\x03','\x06','\x0c','\x19','\x73', // 0x0048
    '\xce','\x3c','\xf8','\xc0','\x81','\xc3','\x46','\x7c', // 0x0050
    '\x70','\x40','\x40','\x05','\xc0','\x80','\x80','\x02', // 0x0058
    '\x00','\x00','\x48','\xc0','\x40','\xc0','\xf8','\x0f', // 0x0060
    '\x01','\x00','\x00','\x17','\x01','\x03','\x06','\x8c', // 0x0068
    '\x08','\x19','\x12','\x36','\x34','\x24','\x25','\x6f', // 0x0070
    '\xcc','\x07','\x1f','\x18','\x00','\x00','\x0a','\x01', // 0x0078
    '\x01','\x02','\x02','\x06','\x0c','\x18','\x20','\xc0', // 0x0080
    '\x80','\x00','\x00','\x40','\x1f','\xf8','\xff','\xff', // 0x0088
    '\x02','\x00','\x00','\x05','\xf0','\x00','\x00','\x13', // 0x0090
    '\x30','\xc8','\x0f','\x00','\x00','\x04','\x02','\xb6', // 0x0098
    '\xac','\xa0','\x00','\x00','\x08','\x04','\x06','\x0f', // 0x00a0
    '\x1f','\x1f','\x02','\x0f','\x0c','\x80','\xc0','\x40', // 0x00a8
    '\xe0','\xb0','\xd0','\x00','\x80','\x7f','\x3c','\x1c', // 0x00b0
    '\x0a','\x0a','\x05','\x08','\x00','\x00','\x3a','\x03', // 0x00b8
    '\x8f','\xfc','\xc0','\x80','\x00','\x00','\x02','\x0f', // 0x00c0
    '\x3c','\xe0','\x80','\x00','\x00','\x10','\x06','\x08', // 0x00c8
    '\x00','\x00','\x08','\x05','\x10','\x20','\x00','\x00', // 0x00d0
    '\x02','\x40','\x00','\x00','\x06','\x10','\x08','\x04', // 0x00d8
    '\x32','\x09','\x06','\x81','\xf1','\x7c','\x0e','\x01', // 0x00e0
    '\x00','\x00','\x45','\x03','\x0c','\x11','\x33','\x66', // 0x00e8
    '\xe0','\xe0','\x02','\xc0','\x40','\x43','\x26','\x3e', // 0x00f0
    '\x18','\x30','\x20','\xa0','\xe0','\xe0','\x02','\xc0', // 0x00f8
    '\x80','\x80','\x08','\x00','\x00','\x02','\x80','\x00', // 0x0100
    '\x00','\x0e','\x80','\x80','\x03','\xc0','\x40','\x60', // 0x0108
    '\x60','\x02','\xb0','\xb8','\xee','\x83','\x00','\x00', // 0x0110
    '\x50','\x01','\x01','\x02','\x03','\x02','\x06','\x04', // 0x0118
    '\x04','\x04','\x06','\x03','\x01','\x01','\x02','\x00', // 0x0120
    '\x00','\x04','\x01','\x01','\x03','\x03','\x03','\x02', // 0x0128
    '\x07','\x04','\x1c','\x18','\x21','\x61','\x41','\x41', // 0x0130
    '\x03','\xc1','\xe1','\xe1','\x02','\x41','\x61','\x39', // 0x0138
    '\x3b','\x1f','\x1c','\x1c','\x02','\x06','\x04','\x04', // 0x0140
    '\x02','\x03','\x03','\x03','\x00','\x00','\x2c',
};

const unsigned char tian13[] PROGMEM = {
    '\xff','\x01','\x6d','\xb5','\xd9','\x6d','\xb5','\xd9', // 0x0008
    '\x6d','\xb5','\xd9','\x6d','\xb5','\xd9','\x6d','\xb5', // 0x0010
    '\xd9','\x6d','\xb5','\xd9','\x6d','\x01','\x01','\x02', // 0x0018
    '\xfd','\x09','\x31','\x09','\xfd','\x01','\xe1','\x51', // 0x0020
    '\x51','\x03','\x61','\x01','\xf1','\x21','\x11','\x11', // 0x0028
    '\x02','\xe1','\x01','\xf1','\x01','\x01','\x02','\x81', // 0x0030
    '\xf1','\x01','\x01','\x05','\x11','\xfd','\x11','\x01', // 0x0038
    '\x81','\x01','\xf1','\x21','\x11','\x11','\x02','\x21', // 0x0040
    '\x01','\x81','\x51','\x51','\x03','\xe1','\x01','\xf1', // 0x0048
    '\x21','\x11','\x11','\x02','\xe1','\x01','\x21','\x51', // 0x0050
    '\x51','\x03','\x81','\x01','\x21','\xf9','\x25','\x05', // 0x0058
    '\x09','\x01','\xe1','\x51','\x51','\x03','\x61','\x01', // 0x0060
    '\xf1','\x21','\x11','\x11','\x02','\x21','\x01','\x01', // 0x0068
    '\x02','\x21','\x21','\x02','\xf9','\x21','\x21','\x02', // 0x0070
    '\x01','\x6d','\xb5','\xd9','\x6d','\xb5','\xd9','\x6d', // 0x0078
    '\xb5','\xd9','\x6d','\xb5','\xd9','\x6d','\xb5','\xd9', // 0x0080
    '\x6d','\xb5','\xd9','\x6d','\xb5','\x01','\xff','\xff', // 0x0088
    '\x02','\x00','\x01','\x01','\x02','\x10','\x31','\x71', // 0x0090
    '\xf0','\xf1','\xf1','\x02','\xf0','\xf1','\xf1','\x02', // 0x0098
    '\xf0','\xf1','\xf1','\x02','\xf0','\xf1','\xf1','\x02', // 0x00a0
    '\xf0','\xf1','\xf0','\xf0','\x02','\xf1','\xf0','\xf0', // 0x00a8
    '\x03','\xf1','\xf0','\xf0','\x02','\xf1','\xf1','\x03', // 0x00b0
    '\xf0','\xf0','\x02','\xf1','\xf0','\xf0','\x03','\xf1', // 0x00b8
    '\xf0','\xf0','\x02','\xf1','\xf1','\x02','\xf0','\xf1', // 0x00c0
    '\xf0','\xf0','\x02','\x70','\x30','\x10','\x00','\x00', // 0x00c8
    '\x02','\x01','\x01','\x02','\x00','\x00','\x02','\x01', // 0x00d0
    '\x00','\x00','\x06','\x01','\x01','\x04','\x00','\x01', // 0x00d8
    '\x00','\x00','\x03','\x01','\x00','\x01','\x01','\x04', // 0x00e0
    '\x00','\x00','\x03','\x01','\x00','\x00','\x05','\x01', // 0x00e8
    '\x01','\x03','\x00','\x00','\x02','\x01','\x00','\x00', // 0x00f0
    '\x0c','\x01','\x01','\x02','\x00','\x01','\x01','\x02', // 0x00f8
    '\x00','\x01','\x01','\x02','\x00','\x01','\x01','\x02', // 0x0100
    '\x00','\x01','\x01','\x02','\x00','\x01','\x01','\x02', // 0x0108
    '\x00','\x01','\x01','\x02','\x00','\xff','\xff','\x02', // 0x0110
    '\x00','\x00','\x07','\x01','\x03','\x07','\x8f','\x9f', // 0x0118
    '\xff','\xff','\x05','\x7f','\x7f','\x02','\x3f','\x3f', // 0x0120
    '\x03','\x1f','\x1f','\x02','\x0f','\x0f','\x02','\x07', // 0x0128
    '\x07','\x02','\x03','\x07','\x1f','\xfd','\xf5','\xc4', // 0x0130
    '\x03','\x0f','\x3f','\xff','\xff','\x02','\x7f','\x3f', // 0x0138
    '\x1f','\x0f','\x07','\x03','\x01','\x00','\x00','\x07', // 0x0140
    '\x01','\xff','\xff','\x02','\x11','\x11','\x02','\xff', // 0x0148
    '\xee','\x00','\x00','\x02','\xf0','\xf8','\x08','\x08', // 0x0150
    '\x02','\xf8','\xf0','\x00','\x00','\x02','\xf0','\xf8', // 0x0158
    '\x08','\x08','\x02','\xf8','\xf0','\x00','\x08','\xfe', // 0x0160
    '\xfe','\x02','\x08','\x08','\x02','\x01','\xff','\xff', // 0x0168
    '\x02','\x00','\x00','\x02','\xf0','\xf8','\x08','\x08', // 0x0170
    '\x02','\xf8','\xf0','\x00','\x00','\x02','\x80','\xd8', // 0x0178
    '\x48','\xf8','\xf0','\x00','\x00','\x02','\xf0','\xf8', // 0x0180
    '\x08','\x09','\xff','\xff','\x02','\x00','\x00','\x02', // 0x0188
    '\xf0','\xf8','\x48','\x78','\x70','\x00','\x08','\xf8', // 0x0190
    '\xf8','\x02','\x10','\x08','\x18','\x00','\x00','\x04', // 0x0198
    '\xff','\xff','\x02','\x00','\x00','\x06','\x1e','\x7e', // 0x01a0
    '\xe7','\x87','\x17','\x0f','\x3f','\xf1','\xc1','\x00', // 0x01a8
    '\x00','\x11','\x03','\x1f','\x7f','\xf8','\xe0','\x81', // 0x01b0
    '\x07','\x1e','\xf8','\xe0','\x80','\x00','\x00','\x0a', // 0x01b8
    '\x02','\x03','\x03','\x02','\x02','\x02','\x02','\x03', // 0x01c0
    '\x01','\x00','\x00','\x02','\x01','\x03','\x02','\x02', // 0x01c8
    '\x02','\x03','\x01','\x00','\x00','\x02','\x01','\x03', // 0x01d0
    '\x02','\x02','\x02','\x03','\x01','\x80','\x80','\x02', // 0x01d8
    '\xc1','\xc3','\x02','\x02','\x03','\x03','\x03','\x02', // 0x01e0
    '\x02','\x00','\x81','\xc3','\x42','\xc2','\x83','\x01', // 0x01e8
    '\x00','\x00','\x02','\x01','\x03','\x02','\xc3','\xc3', // 0x01f0
    '\x02','\x02','\x00','\x01','\x03','\x02','\x02','\x02', // 0x01f8
    '\x03','\x03','\x02','\x02','\x00','\x01','\x03','\x02', // 0x0200
    '\x02','\x03','\x00','\x02','\x03','\x03','\x02','\x02', // 0x0208
    '\x00','\x00','\x06','\xff','\xff','\x02','\x00','\x00', // 0x0210
    '\x08','\x01','\x07','\x3e','\xf8','\xc0','\x00','\x03', // 0x0218
    '\x0f','\x3c','\xf0','\xc0','\x00','\x00','\x03','\x80', // 0x0220
    '\x80','\x02','\xc0','\xc0','\x02','\x60','\x60','\x02', // 0x0228
    '\x30','\x30','\x02','\x98','\x98','\x02','\xcc','\xcc', // 0x0230
    '\x02','\xe4','\x67','\x67','\x02','\x33','\xf0','\xc0', // 0x0238
    '\x00','\x03','\x0f','\x7e','\xf0','\xc0','\x00','\x00', // 0x0240
    '\x14','\x02','\x0e','\x3e','\xf2','\xc0','\x32','\x0e', // 0x0248
    '\x02','\x00','\x00','\x02','\x80','\x80','\x02','\xff', // 0x0250
    '\xff','\x02','\x80','\x80','\x02','\x00','\xc0','\xc0', // 0x0258
    '\x02','\x00','\x3f','\x7f','\xc0','\x80','\xc0','\x7f', // 0x0260
    '\x3f','\x00','\x80','\xe0','\x98','\x17','\x10','\x17', // 0x0268
    '\x9f','\xf8','\xe0','\x80','\x00','\x00','\x16','\xff', // 0x0270
    '\xff','\x02','\x00','\x00','\x0c','\x03','\x0f','\x7c', // 0x0278
    '\xf0','\x80','\x00','\x03','\x03','\x03','\x3b','\xf9', // 0x0280
    '\xd9','\x0c','\x2c','\xf6','\xf6','\x02','\xe3','\x83', // 0x0288
    '\x01','\x01','\x02','\x00','\x01','\x07','\x9f','\xfc', // 0x0290
    '\xf0','\xc0','\xc3','\xff','\xfc','\x70','\x70','\x02', // 0x0298
    '\x31','\x3f','\x3f','\x02','\x1c','\x00','\x00','\x05', // 0x02a0
    '\xc0','\x40','\x40','\x43','\xc0','\x00','\x00','\x04', // 0x02a8
    '\xff','\xff','\x02','\x00','\x00','\x07','\x80','\xc0', // 0x02b0
    '\xe0','\xf0','\xf8','\xfc','\xfe','\xff','\xff','\x03', // 0x02b8
    '\xfe','\xf8','\xe0','\xe0','\x04','\xe3','\xff','\xfc', // 0x02c0
    '\xf8','\xf9','\xfd','\xfd','\x02','\xfc','\xfe','\xfe', // 0x02c8
    '\x02','\xff','\xff','\x07','\xfc','\xf8','\xf0','\xe0', // 0x02d0
    '\xc0','\x80','\x00','\x00','\x07','\xff','\x00','\x7f', // 0x02d8
    '\x7f','\x18','\x00','\x00','\x2a','\xff','\x00','\x00', // 0x02e0
    '\x04','\xff','\xff','\x02','\x80','\x80','\x04','\x84', // 0x02e8
    '\x86','\x87','\x87','\x29','\x86','\x84','\x80','\x80', // 0x02f0
    '\x04','\x81','\x81','\x45','\x80','\x80','\x04','\xff', // 0x02f8
};

const unsigned char tian14[] PROGMEM = {
    '\x00','\x00','\x03','\x04','\x3c','\xec','\x54','\xac', // 0x0008
    '\x54','\xac','\x58','\xe0','\x00','\x00','\x1d','\xc0', // 0x0010
    '\x60','\xa0','\x50','\xa8','\x58','\xac','\x54','\xac', // 0x0018
    '\x54','\xac','\x54','\xac','\x54','\xac','\x54','\xac', // 0x0020
    '\x54','\xac','\x54','\xac','\x54','\xac','\x54','\xac', // 0x0028
    '\x54','\xac','\x54','\xac','\x54','\xac','\x58','\xa8', // 0x0030
    '\x58','\xb4','\x54','\xac','\x54','\x9c','\x34','\x6c', // 0x0038
    '\xd4','\xac','\x54','\xac','\x54','\xac','\x54','\xac', // 0x0040
    '\x54','\xac','\x54','\xac','\x54','\xac','\x54','\xac', // 0x0048
    '\x54','\xac','\x54','\xac','\x54','\xac','\x54','\xac', // 0x0050
    '\x54','\xac','\x54','\xac','\x54','\xa8','\x58','\xa8', // 0x0058
    '\x50','\xa0','\x60','\x80','\x00','\x00','\x0f','\x01', // 0x0060
    '\x07','\x3a','\xd5','\xaa','\x55','\xaa','\x57','\xbc', // 0x0068
    '\xe0','\x00','\x00','\x16','\x80','\x70','\xae','\x55', // 0x0070
    '\xaa','\x55','\xaa','\x55','\xea','\x55','\xaa','\x55', // 0x0078
    '\xaa','\x55','\xaa','\xfd','\x01','\x01','\x0f','\x03', // 0x0080
    '\x02','\x03','\x02','\x05','\x06','\x0d','\x1a','\x35', // 0x0088
    '\x6a','\xd5','\xaa','\x55','\xaa','\x54','\xb9','\x61', // 0x0090
    '\x81','\x01','\x01','\x17','\x02','\x03','\x06','\x0d', // 0x0098
    '\x7a','\xd5','\xaa','\x55','\xaa','\x57','\xac','\xf0', // 0x00a0
    '\x00','\x00','\x10','\x07','\x3d','\xea','\x55','\xaa', // 0x00a8
    '\x55','\xaf','\x58','\xe0','\x00','\x00','\x10','\x80', // 0x00b0
    '\xf0','\x5e','\xab','\x55','\xaa','\xd5','\x6a','\x1d', // 0x00b8
    '\x03','\x00','\xff','\x55','\xaa','\x55','\xaa','\x55', // 0x00c0
    '\xaa','\xff','\x00','\x00','\x0a','\xf8','\xfe','\xde', // 0x00c8
    '\x7f','\xff','\x5f','\xdf','\xbe','\xfe','\xf8','\xe0', // 0x00d0
    '\x00','\x00','\x04','\x01','\x1e','\xf5','\xaa','\x55', // 0x00d8
    '\xaa','\x55','\xaf','\xf8','\x00','\x00','\x13','\x80', // 0x00e0
    '\x80','\x03','\xc0','\x40','\xa0','\x58','\xaf','\x55', // 0x00e8
    '\xaa','\x55','\xaa','\x55','\xea','\x1f','\x00','\x00', // 0x00f0
    '\x13','\x07','\x1a','\xf5','\xaa','\x55','\xaa','\x57', // 0x00f8
    '\xb8','\xc0','\x00','\x00','\x0a','\x80','\x70','\xae', // 0x0100
    '\x55','\xaa','\x55','\xaa','\x75','\x0e','\x03','\x00', // 0x0108
    '\x00','\x04','\xff','\x55','\xaa','\x55','\xaa','\x55', // 0x0110
    '\xaa','\xff','\x00','\x00','\x07','\x80','\xc0','\xf0', // 0x0118
    '\x19','\x0f','\x02','\x0d','\x0a','\x05','\x02','\x03', // 0x0120
    '\x0f','\x7f','\xff','\xf8','\xe0','\xc0','\x00','\x00', // 0x0128
    '\x03','\xff','\xaa','\x55','\xaa','\x55','\xaa','\x55', // 0x0130
    '\xeb','\x75','\x6b','\x55','\x6b','\x55','\x6b','\x55', // 0x0138
    '\x6b','\x55','\x6b','\x55','\x6b','\xd5','\xab','\x55', // 0x0140
    '\xab','\x55','\xab','\x55','\xaa','\x55','\xaa','\x35', // 0x0148
    '\x2a','\x15','\x1a','\x0d','\x0a','\x05','\x02','\x01', // 0x0150
    '\x00','\x00','\x18','\x03','\x1d','\xea','\x55','\xaa', // 0x0158
    '\x55','\xae','\x78','\xc0','\x00','\x00','\x04','\xc0', // 0x0160
    '\xb0','\x5e','\xab','\x55','\xaa','\xd5','\x6a','\x1d', // 0x0168
    '\x03','\x00','\x00','\x07','\xff','\x55','\xaa','\x55', // 0x0170
    '\xaa','\x55','\xaa','\xff','\x00','\x00','\x02','\x80', // 0x0178
    '\x80','\x03','\x70','\xbc','\x7f','\xc3','\x80','\x80', // 0x0180
    '\x02','\x00','\x00','\x08','\xc0','\x81','\xff','\xff', // 0x0188
    '\x04','\xfc','\xff','\xff','\x02','\xaa','\x55','\xaa', // 0x0190
    '\x55','\xea','\x3f','\x00','\x00','\x0f','\x01','\x02', // 0x0198
    '\x05','\x0a','\x15','\x6a','\xd5','\xaa','\x55','\xaa', // 0x01a0
    '\x54','\xa8','\x50','\xe0','\x80','\x00','\x00','\x1d', // 0x01a8
    '\x03','\x1e','\x75','\xaa','\x55','\xab','\x5e','\xa0', // 0x01b0
    '\x60','\xbe','\x55','\xaa','\x55','\xaa','\x75','\x0e', // 0x01b8
    '\x03','\x00','\x00','\x0a','\xff','\x55','\xaa','\x55', // 0x01c0
    '\xaa','\x55','\xaa','\x7f','\xc0','\x44','\xfb','\x75', // 0x01c8
    '\xea','\x75','\xea','\x75','\xea','\x75','\xff','\x73', // 0x01d0
    '\xf0','\x70','\xf0','\x70','\xf8','\x78','\xfc','\x77', // 0x01d8
    '\xea','\x55','\xea','\x75','\xba','\x5d','\xaf','\xd7', // 0x01e0
    '\x6a','\x35','\x1a','\x07','\x01','\x00','\x00','\x17', // 0x01e8
    '\x03','\x05','\x1a','\x75','\xaa','\x55','\xaa','\x55', // 0x01f0
    '\xaa','\x5c','\xb0','\x60','\x80','\x00','\x00','\x1b', // 0x01f8
    '\x03','\x0d','\x3a','\x35','\x2a','\x35','\x2a','\x35', // 0x0200
    '\x2a','\x1d','\x03','\x00','\x00','\x0d','\x3f','\x35', // 0x0208
    '\x2a','\x35','\x2a','\x35','\x2a','\x35','\x2a','\x35', // 0x0210
    '\x2a','\x35','\x2a','\x35','\x2a','\x35','\x2a','\x35', // 0x0218
    '\x2a','\x35','\x2a','\x35','\x2a','\x15','\x1a','\x15', // 0x0220
    '\x1a','\x0d','\x0a','\x0d','\x06','\x05','\x06','\x03', // 0x0228
    '\x01','\x00','\x00','\x22','\x03','\x06','\x1d','\x2a', // 0x0230
    '\x35','\x2a','\x35','\x2a','\x37','\x2c','\x38','\x00', // 0x0238
    '\x00','\x06','\x0f','\x3f','\x60','\x60','\x02','\x3f', // 0x0240
    '\x0f','\x00','\x00','\x02','\x7f','\x7f','\x02','\x00', // 0x0248
    '\x00','\x02','\x7f','\x7f','\x02','\x63','\x63','\x02', // 0x0250
    '\x3e','\x1c','\x00','\x00','\x02','\x7f','\x7f','\x02', // 0x0258
    '\x6b','\x63','\x00','\x00','\x02','\x1c','\x3e','\x63', // 0x0260
    '\x63','\x02','\x3e','\x1c','\x00','\x00','\x06','\x7f', // 0x0268
    '\x7f','\x02','\x63','\x63','\x02','\x3e','\x1c','\x00', // 0x0270
    '\x00','\x02','\x7f','\x7f','\x02','\x00','\x00','\x02', // 0x0278
    '\x66','\x6f','\x7b','\x33','\x00','\x00','\x02','\x7f', // 0x0280
    '\x7f','\x02','\x0c','\x77','\x63','\x00','\x00','\x06', // 0x0288
    '\x7f','\x7f','\x02','\x09','\x1d','\x7f','\x66','\x00', // 0x0290
    '\x00','\x02','\x7f','\x7f','\x02','\x6b','\x63','\x00', // 0x0298
    '\x00','\x02','\x1c','\x3e','\x77','\x63','\x63','\x02', // 0x02a0
    '\x00','\x00','\x02','\x1c','\x3e','\x63','\x63','\x02', // 0x02a8
    '\x3e','\x1c','\x00','\x00','\x02','\x7f','\x7f','\x02', // 0x02b0
    '\x09','\x1d','\x7f','\x66','\x00','\x00','\x02','\x7f', // 0x02b8
    '\x7f','\x02','\x63','\x63','\x02','\x3e','\x1c','\x00', // 0x02c0
    '\x00','\x02','\x7f','\x7f','\x02','\x6b','\x63','\x00', // 0x02c8
    '\x00','\x02','\x7f','\x7f','\x02','\x09','\x1d','\x7f', // 0x02d0
    '\x66','\x00','\x00',
};
const unsigned char tian15[] PROGMEM = {
    '\x80','\xc0','\xa0','\x90','\x90','\x2a','\x50','\x30', // 0x0008
    '\xf0','\x00','\x80','\xc0','\xa0','\x90','\x90','\x18', // 0x0010
    '\x50','\x30','\xf0','\x00','\x80','\xc0','\xa0','\x90', // 0x0018
    '\x90','\x2a','\x50','\x30','\xf0','\xff','\x00','\x00', // 0x0020
    '\x2b','\xff','\x00','\x00','\x02','\xff','\x00','\xff', // 0x0028
    '\xfe','\x02','\x02','\x17','\xfe','\xff','\x00','\x00', // 0x0030
    '\x02','\xff','\x00','\xff','\x00','\x00','\x2b','\xff', // 0x0038
    '\x00','\x00','\x02','\xff','\xff','\x02','\x00','\x00', // 0x0040
    '\x2b','\xff','\x00','\x00','\x02','\xff','\x00','\xff', // 0x0048
    '\x7f','\x40','\x40','\x17','\x7f','\xff','\x00','\x00', // 0x0050
    '\x02','\xff','\x00','\xff','\x00','\x00','\x2b','\xff', // 0x0058
    '\x00','\x00','\x02','\xff','\x1f','\x10','\x90','\x50', // 0x0060
    '\x50','\x29','\x5f','\x48','\xc4','\xc3','\x00','\xff', // 0x0068
    '\xfe','\x02','\x02','\x17','\xfe','\xff','\x00','\x00', // 0x0070
    '\x02','\xff','\x00','\x1f','\x10','\x10','\x02','\x90', // 0x0078
    '\x90','\x29','\x9f','\x88','\x84','\x83','\xfe','\x07', // 0x0080
    '\x0a','\x12','\x22','\x42','\x02','\x02','\x06','\x06', // 0x0088
    '\x1a','\x22','\x02','\x02','\x07','\x1e','\x02','\x02', // 0x0090
    '\x07','\x22','\x1a','\x06','\x02','\x02','\x06','\x42', // 0x0098
    '\x22','\x12','\x0a','\x06','\xfe','\x01','\x00','\xff', // 0x00a0
    '\x00','\xff','\x7f','\x40','\x40','\x17','\x7f','\xff', // 0x00a8
    '\x00','\x00','\x02','\xff','\x00','\xfc','\x0e','\x15', // 0x00b0
    '\x24','\x44','\x84','\x04','\x04','\x06','\x0c','\x34', // 0x00b8
    '\x44','\x04','\x04','\x07','\x3c','\x04','\x04','\x07', // 0x00c0
    '\x44','\x34','\x0c','\x04','\x04','\x06','\x84','\x44', // 0x00c8
    '\x24','\x14','\x0c','\xfc','\x02','\x01','\xff','\xff', // 0x00d0
    '\x02','\x08','\x08','\x02','\x10','\x00','\x00','\x25', // 0x00d8
    '\x20','\x10','\x10','\x02','\xff','\x00','\x00','\x02', // 0x00e0
    '\xff','\x00','\xff','\xfe','\x02','\x02','\x17','\xfe', // 0x00e8
    '\xff','\x00','\x00','\x02','\xff','\x00','\xff','\x10', // 0x00f0
    '\x10','\x02','\x20','\x00','\x00','\x25','\x40','\x20', // 0x00f8
    '\x20','\x02','\xff','\x00','\x00','\x02','\xff','\xff', // 0x0100
    '\x02','\x40','\x60','\x40','\x60','\x40','\x60','\x40', // 0x0108
    '\x60','\x40','\x60','\x40','\x60','\x40','\x60','\x40', // 0x0110
    '\x60','\x40','\x60','\x40','\x60','\x40','\x78','\x40', // 0x0118
    '\x60','\x40','\x60','\x40','\x60','\x40','\x60','\x40', // 0x0120
    '\x60','\x40','\x60','\x40','\x60','\x40','\x60','\x40', // 0x0128
    '\x60','\x40','\x60','\x40','\xff','\x00','\x00','\x02', // 0x0130
    '\xff','\x00','\xff','\x7f','\x40','\x40','\x17','\x7f', // 0x0138
    '\xff','\x00','\x00','\x02','\xff','\x00','\xff','\x80', // 0x0140
    '\xc0','\x80','\xc0','\x80','\xc0','\x80','\xc0','\x80', // 0x0148
    '\xc0','\x80','\xc0','\x80','\xc0','\x80','\xc0','\x80', // 0x0150
    '\xc0','\x80','\xc0','\x80','\xf0','\x80','\xc0','\x80', // 0x0158
    '\xc0','\x80','\xc0','\x80','\xc0','\x80','\xc0','\x80', // 0x0160
    '\xc0','\x80','\xc0','\x80','\xc0','\x80','\xc0','\x80', // 0x0168
    '\xc0','\x80','\xff','\x00','\x00','\x02','\xff','\x7f', // 0x0170
    '\x40','\x40','\x0c','\x4f','\x50','\x4f','\x40','\x5f', // 0x0178
    '\x50','\x5f','\x40','\x40','\x03','\x5f','\x50','\x40', // 0x0180
    '\x5f','\x55','\x40','\x5f','\x45','\x40','\x41','\x5f', // 0x0188
    '\x41','\x40','\x40','\x09','\x7f','\x20','\x10','\x0f', // 0x0190
    '\x00','\x7f','\x40','\x5f','\x51','\x51','\x15','\x5f', // 0x0198
    '\x40','\x7f','\x20','\x10','\x0f','\x00','\xff','\x80', // 0x01a0
    '\x80','\x08','\x9e','\xa0','\x9e','\x80','\xbe','\xa0', // 0x01a8
    '\xbe','\x80','\x80','\x03','\xbe','\x9a','\xae','\x80', // 0x01b0
    '\xbe','\x80','\xbe','\xaa','\xba','\x80','\x82','\xbe', // 0x01b8
    '\x82','\x80','\xbe','\x88','\xbe','\x80','\x80','\x08', // 0x01c0
    '\xff','\x40','\x20','\x1f',
};
const unsigned char tian16[] PROGMEM = {
    '\x49','\x24','\x12','\x49','\x24','\x12','\x49','\x24', // 0x0008
    '\x12','\x49','\x24','\x12','\x49','\x24','\x12','\x49', // 0x0010
    '\x24','\x12','\x49','\x24','\x12','\x49','\x24','\x12', // 0x0018
    '\x49','\x24','\x12','\x49','\x24','\x12','\x49','\x24', // 0x0020
    '\x12','\x49','\x00','\x00','\x04','\x7f','\x02','\x0c', // 0x0028
    '\x02','\x7f','\x00','\x7e','\x09','\x09','\x03','\x7e', // 0x0030
    '\x00','\x00','\x02','\x41','\x7f','\x41','\x00','\x00', // 0x0038
    '\x02','\x7f','\x04','\x08','\x10','\x7f','\x00','\x00', // 0x0040
    '\x06','\x7f','\x02','\x0c','\x02','\x7f','\x00','\x7f', // 0x0048
    '\x49','\x49','\x03','\x41','\x00','\x7f','\x04','\x08', // 0x0050
    '\x10','\x7f','\x00','\x3f','\x40','\x40','\x03','\x3f', // 0x0058
    '\x00','\x00','\x04','\x49','\x24','\x12','\x49','\x24', // 0x0060
    '\x12','\x49','\x24','\x12','\x49','\x24','\x12','\x49', // 0x0068
    '\x24','\x12','\x49','\x24','\x12','\x49','\x24','\x12', // 0x0070
    '\x49','\x24','\x12','\x49','\x24','\x12','\x49','\x24', // 0x0078
    '\x12','\x49','\x24','\x12','\x49','\x00','\x0e','\x11', // 0x0080
    '\x15','\x1d','\x00','\x9f','\x45','\x4d','\x52','\x80', // 0x0088
    '\x1e','\x05','\x05','\x02','\x1e','\xc0','\x1f','\x85', // 0x0090
    '\x45','\x02','\x80','\x5f','\x04','\x04','\x02','\x1f', // 0x0098
    '\x00','\x00','\x04','\xff','\x00','\x1f','\x11','\xd1', // 0x00a0
    '\x0e','\x00','\x01','\xc2','\x1c','\x02','\x01','\xc0', // 0x00a8
    '\x1f','\x02','\x04','\xdf','\x00','\x1e','\x05','\xc5', // 0x00b0
    '\x1e','\x00','\x00','\x08','\xff','\x00','\xc1','\x01', // 0x00b8
    '\x5f','\x81','\x41','\x00','\xde','\x05','\x05','\x02', // 0x00c0
    '\x1e','\x00','\x1f','\xd5','\x15','\x0a','\x00','\x1f', // 0x00c8
    '\x10','\xd0','\x00','\x1f','\x15','\x15','\x03','\xc0', // 0x00d0
    '\x00','\x00','\x03','\xff','\x00','\x1f','\x05','\x0d', // 0x00d8
    '\x12','\x00','\x1f','\x15','\x15','\x03','\x00','\x0e', // 0x00e0
    '\x11','\x11','\x03','\x00','\x0f','\x10','\x10','\x02', // 0x00e8
    '\x0f','\x80','\x5f','\x05','\x0d','\x12','\x00','\x00', // 0x00f0
    '\x04','\xff','\x00','\x04','\x02','\x7f','\x02','\x04', // 0x00f8
    '\x00','\x00','\x04','\x08','\xc8','\x38','\x0e','\x09', // 0x0100
    '\x08','\x08','\x02','\x88','\x49','\x2e','\x38','\x48', // 0x0108
    '\x8c','\xff','\x89','\x48','\x38','\x0e','\x09','\x08', // 0x0110
    '\x00','\xf8','\x88','\xa8','\xa8','\x03','\x68','\xff', // 0x0118
    '\x00','\x00','\x02','\x80','\x83','\x8c','\x90','\xa0', // 0x0120
    '\xc3','\xcc','\xb0','\xc0','\xff','\xc0','\xb0','\xcc', // 0x0128
    '\xc3','\xa0','\x90','\x8c','\x83','\x80','\x00','\x00', // 0x0130
    '\x02','\xf8','\x18','\xa8','\xa8','\x03','\x78','\xff', // 0x0138
    '\x00','\xff','\x04','\x15','\x64','\x15','\x04','\xff', // 0x0140
    '\x04','\x04','\x05','\xff','\x04','\x04','\x05','\xff', // 0x0148
    '\x04','\x04','\x02','\x00','\xf8','\xe8','\xeb','\x68', // 0x0150
    '\xa8','\xc8','\xff','\x00','\x00','\x03','\xc0','\x30', // 0x0158
    '\xc8','\x44','\x44','\x02','\x42','\x42','\x02','\x7f', // 0x0160
    '\x81','\x41','\x3f','\x11','\x1b','\x15','\x1b','\x11', // 0x0168
    '\x3f','\xc0','\x00','\x00','\x02','\xf8','\x58','\xa8', // 0x0170
    '\xa8','\x03','\x58','\xff','\x00','\x00','\x09','\x72', // 0x0178
    '\x8a','\x8a','\x03','\x02','\x72','\x8a','\x8a','\x02', // 0x0180
    '\x72','\x02','\xfa','\x12','\x22','\xfa','\x02','\xfa', // 0x0188
    '\x02','\x72','\x8a','\x8a','\x03','\x02','\x93','\xaa', // 0x0190
    '\xaa','\x02','\x4a','\x02','\x03','\xfb','\x00','\xfa', // 0x0198
    '\xaa','\xaa','\x03','\x02','\x72','\x8a','\x4a','\xb2', // 0x01a0
    '\x02','\x7a','\x82','\x82','\x02','\x7a','\x02','\xf2', // 0x01a8
    '\x2a','\x2a','\x02','\xf2','\x02','\x02','\x03','\x03', // 0x01b0
    '\x03','\x02','\x02','\x02','\x03','\x03','\xfb','\x00', // 0x01b8
    '\xfa','\x2a','\x2a','\x02','\x12','\x02','\xfa','\x2a', // 0x01c0
    '\x6a','\x92','\x02','\x72','\x8a','\xaa','\xea','\x02', // 0x01c8
    '\xfa','\x12','\x22','\x12','\xfa','\x02','\x02','\x02', // 0x01d0
    '\x03','\x03','\x03','\x02','\x03','\x03','\x02','\xfb', // 0x01d8
    '\x00','\x0a','\x0a','\x02','\xfb','\x0a','\x0b','\x02', // 0x01e0
    '\x3a','\x42','\x82','\x43','\x3a','\x02','\xfa','\x12', // 0x01e8
    '\x22','\x12','\xfa','\x02','\x02','\x03','\x03','\x02', // 0x01f0
    '\x03','\x03','\x02','\x02','\x02','\x03','\x03','\xfb', // 0x01f8
    '\x00','\x00','\x0a','\x40','\x40','\x02','\xe0','\x50', // 0x0200
    '\x48','\x48','\x02','\x44','\x44','\x03','\xfe','\x44', // 0x0208
    '\x44','\x03','\x48','\x48','\x02','\x50','\xe0','\x40', // 0x0210
    '\x40','\x02','\x00','\x00','\x02','\xc0','\xc0','\x02', // 0x0218
    '\x40','\x40','\x03','\xc0','\xff','\x00','\x00','\x02', // 0x0220
    '\x10','\x2a','\x2a','\x02','\x3c','\x00','\x22','\x94', // 0x0228
    '\x88','\x94','\x22','\x00','\x8e','\x44','\x42','\x8c', // 0x0230
    '\x00','\x08','\x1c','\x08','\x00','\x00','\x02','\xc0', // 0x0238
    '\xc0','\x02','\x40','\x40','\x03','\xc0','\xff','\x00', // 0x0240
    '\x00','\x04','\xfc','\x02','\xfa','\xaa','\xfa','\xaa', // 0x0248
    '\xfa','\xaa','\xfa','\xea','\xfa','\xfa','\x03','\x02', // 0x0250
    '\xfc','\xf8','\xf0','\x00','\x00','\x02','\xc0','\x40', // 0x0258
    '\x40','\x04','\xc0','\xff','\x00','\x00','\x02','\x48', // 0x0260
    '\x50','\xe0','\x50','\x48','\x00','\x20','\x50','\xf8', // 0x0268
    '\x50','\x90','\x00','\x3e','\x0a','\x0a','\x02','\x00', // 0x0270
    '\x3e','\x0a','\x0a','\x02','\x00','\x00','\x02','\xc0', // 0x0278
    '\xc0','\x02','\x40','\x40','\x04','\xff','\x00','\x00', // 0x0280
    '\x09','\xd0','\x50','\x50','\x03','\x11','\x12','\x12', // 0x0288
    '\x02','\x14','\x94','\x54','\x5f','\x54','\x14','\x94', // 0x0290
    '\x52','\x52','\x02','\x91','\x10','\xd0','\x90','\x10', // 0x0298
    '\xd0','\x1f','\x5e','\x55','\x55','\x02','\x95','\x18', // 0x02a0
    '\xdf','\x00','\xd0','\x11','\x10','\x11','\x10','\x51', // 0x02a8
    '\xd0','\x52','\x12','\xd2','\x90','\x10','\xd3','\x14', // 0x02b0
    '\xd4','\x13','\x90','\x50','\x10','\x10','\x04','\x1f', // 0x02b8
    '\x10','\x1d','\x1d','\x03','\x10','\xdf','\xe0','\x38', // 0x02c0
    '\x74','\xf2','\x79','\x34','\xfa','\x34','\xba','\xb4', // 0x02c8
    '\xfa','\x34','\x7a','\xf4','\x72','\x38','\xfc','\x7e', // 0x02d0
    '\xbf','\x77','\xf3','\x30','\xb0','\x7f','\xf0','\x35', // 0x02d8
    '\xf5','\x35','\xfa','\x3f','\x00','\x90','\x51','\x51', // 0x02e0
    '\x02','\x13','\x51','\x91','\x10','\x91','\x51','\x13', // 0x02e8
    '\x91','\x50','\x50','\x02','\x10','\x50','\xd0','\x50', // 0x02f0
    '\x10','\xd0','\x50','\x50','\x02','\x10','\xdf','\x98', // 0x02f8
    '\x17','\x97','\xd7','\x17','\xdf','\x00','\x00','\x09', // 0x0300
    '\x07','\x05','\xc5','\x85','\x10','\x21','\x41','\x00', // 0x0308
    '\x03','\xf4','\x04','\x44','\x00','\x43','\x04','\x44', // 0x0310
    '\x03','\x00','\x07','\x00','\xf1','\x07','\x00','\x06', // 0x0318
    '\x05','\x05','\x02','\x04','\x00','\xff','\x00','\x07', // 0x0320
    '\xf4','\x14','\xd4','\xd0','\xd4','\x17','\xf4','\x00', // 0x0328
    '\x87','\x00','\x01','\x07','\xf0','\x17','\xd1','\xd2', // 0x0330
    '\xd4','\x10','\xf0','\x00','\x00','\x08','\xff','\xff', // 0x0338
    '\x02','\xf8','\xff','\xfe','\xff','\xf8','\xff','\x18', // 0x0340
    '\x3a','\x1a','\x8f','\xc8','\xcf','\xce','\xcf','\xf8', // 0x0348
    '\x1f','\xec','\xeb','\xec','\x1f','\x38','\xfe','\xf9', // 0x0350
    '\xff','\xfe','\xf9','\xfe','\xff','\x00','\x00','\x02', // 0x0358
    '\x04','\x05','\xe2','\xc0','\x90','\xb0','\xf7','\xe0', // 0x0360
    '\xa0','\xa0','\x02','\xa4','\xa5','\xa2','\xa0','\xa0', // 0x0368
    '\x02','\xa7','\xa0','\xa0','\x02','\xa7','\xa5','\x45', // 0x0370
    '\x00','\x07','\x00','\x01','\x00','\x07','\x00','\xff', // 0x0378
    '\x00','\x00','\x09','\x98','\x9c','\x8f','\x80','\xa3', // 0x0380
    '\x90','\x88','\x80','\x80','\x02','\x9f','\xa0','\xa7', // 0x0388
    '\xa0','\xa6','\xa9','\xa9','\x02','\xa6','\xa0','\xa7', // 0x0390
    '\xa0','\x9f','\x80','\xfe','\x82','\xba','\xba','\x03', // 0x0398
    '\xc6','\xff','\x00','\x80','\xbf','\xa0','\xaa','\xa0', // 0x03a0
    '\xaa','\xa0','\xbf','\x83','\x80','\x83','\x84','\x83', // 0x03a8
    '\xbf','\xa0','\xaa','\xa0','\xaa','\xa0','\xbf','\x80', // 0x03b0
    '\x80','\x02','\xfe','\x82','\xaa','\xaa','\x03','\xba', // 0x03b8
    '\xff','\xff','\x02','\x60','\x4e','\x4e','\x03','\x40', // 0x03c0
    '\x43','\x7e','\x4e','\x4e','\x03','\x4f','\x45','\x61', // 0x03c8
    '\x71','\x61','\x7f','\x7e','\x7c','\x7c','\x03','\x7e', // 0x03d0
    '\x7f','\x01','\x7d','\x15','\x15','\x03','\x05','\x00', // 0x03d8
    '\x00','\x02','\x80','\x80','\x02','\x9c','\x95','\x95', // 0x03e0
    '\x03','\x89','\x88','\x88','\x02','\x9c','\x94','\x94', // 0x03e8
    '\x02','\xbe','\xaa','\xaa','\x06','\x9c','\x80','\x80', // 0x03f0
    '\x02','\xfe','\xc6','\xba','\xaa','\xaa','\x02','\x8a', // 0x03f8
    '\xff','\x00','\x00','\x08',
};
/*
// FightCube
    '\xff','\xff','\x14','\x7f','\x7f','\x02','\x3f','\xbf', // 0x0008
    '\x5f','\x9f','\x4f','\xaf','\x57','\xa7','\x53','\xab', // 0x0010
    '\x55','\xa9','\x55','\xab','\x53','\xa7','\x57','\xaf', // 0x0018
    '\x4f','\x9f','\x5f','\xbf','\x3f','\x7f','\x7f','\x02', // 0x0020
    '\xff','\xff','\x55','\x7f','\x7f','\x02','\x3f','\xbf', // 0x0028
    '\x5f','\x9f','\x4f','\xaf','\x57','\xa7','\x53','\xab', // 0x0030
    '\x55','\xa9','\x54','\x2a','\x55','\x2a','\x15','\x0a', // 0x0038
    '\x05','\x0a','\x05','\x02','\x01','\x02','\x01','\x00', // 0x0040
    '\x00','\x02','\xfe','\x55','\xfc','\xa9','\xfa','\x55', // 0x0048
    '\xf2','\xa5','\xea','\x55','\xca','\x95','\xaa','\x55', // 0x0050
    '\x2a','\x54','\xa9','\x53','\xab','\x57','\xa7','\x4f', // 0x0058
    '\xaf','\x5f','\x9f','\x3f','\xbf','\x7f','\x7f','\x02', // 0x0060
    '\xff','\xff','\x04','\x3f','\x3f','\x02','\xbf','\xbf', // 0x0068
    '\x05','\xff','\xbf','\xbf','\x02','\xff','\xff','\x08', // 0x0070
    '\x3f','\x3f','\x02','\xff','\xff','\x06','\x7f','\x3f', // 0x0078
    '\xff','\xff','\x04','\x7f','\x3f','\xbf','\xbf','\x03', // 0x0080
    '\x3f','\x7f','\xff','\xff','\x08','\x3f','\x3f','\x02', // 0x0088
    '\xff','\xff','\x0e','\x01','\xfc','\x56','\xfd','\xac', // 0x0090
    '\xf9','\x5a','\xf5','\xb2','\xe5','\x0a','\x05','\x02', // 0x0098
    '\x01','\x02','\x01','\x00','\x00','\x07','\xc0','\x80', // 0x00a0
    '\x80','\x02','\x20','\x50','\xa0','\x50','\xa8','\x54', // 0x00a8
    '\xa9','\x55','\xab','\x52','\xa7','\x55','\xaf','\x4a', // 0x00b0
    '\xaf','\x55','\xa7','\x52','\xa9','\x55','\xaa','\x55', // 0x00b8
    '\x2a','\x15','\x2a','\x15','\x0a','\x05','\x02','\x05', // 0x00c0
    '\x02','\x01','\x00','\x01','\x00','\x00','\x02','\xff', // 0x00c8
    '\xff','\x03','\x80','\x80','\x02','\xfb','\xfb','\x04', // 0x00d0
    '\xff','\xff','\x02','\x80','\x80','\x02','\xff','\xc1', // 0x00d8
    '\x80','\xbe','\xbe','\x02','\x01','\x00','\xff','\x80', // 0x00e0
    '\x80','\x02','\xfe','\xfe','\x02','\x81','\x81','\x02', // 0x00e8
    '\xff','\xfe','\xc0','\x80','\xbe','\xbf','\xff','\xe0', // 0x00f0
    '\xc0','\x9f','\xbf','\xbf','\x03','\x8e','\xce','\xff', // 0x00f8
    '\xc0','\x80','\xbf','\xbf','\x02','\xc0','\x80','\xff', // 0x0100
    '\x80','\x80','\x02','\xd9','\xbe','\xbe','\x02','\x81', // 0x0108
    '\xc3','\xff','\xc1','\x80','\xb6','\xb6','\x02','\xb0', // 0x0110
    '\xb1','\xff','\xff','\x02','\x00','\xff','\x55','\xff', // 0x0118
    '\xaa','\xff','\x55','\xff','\xaa','\xff','\x00','\x00', // 0x0120
    '\x0b','\x80','\x40','\x9f','\x0a','\xe7','\x65','\xd3', // 0x0128
    '\xca','\x94','\xaa','\x55','\x2a','\x55','\x2a','\x15', // 0x0130
    '\x0a','\x05','\x0a','\x05','\x02','\x01','\x02','\x01', // 0x0138
    '\x00','\x00','\x12','\xff','\xff','\x0e','\xfe','\xfc', // 0x0140
    '\xfd','\xfd','\x02','\xfc','\xfe','\xff','\xff','\x2e', // 0x0148
    '\x00','\xff','\x55','\xff','\xaa','\xff','\x55','\xff', // 0x0150
    '\xaa','\xff','\x00','\x00','\x09','\xff','\xaa','\xfe', // 0x0158
    '\x55','\xfa','\xa8','\xff','\x55','\xff','\xaa','\xff', // 0x0160
    '\x55','\xff','\x00','\x00','\x1e','\xff','\xff','\x02', // 0x0168
    '\xfc','\xff','\xfc','\xff','\xff','\x02','\xfe','\xfe', // 0x0170
    '\x02','\x80','\x80','\x02','\xfe','\xfe','\x02','\xff', // 0x0178
    '\x80','\x80','\x02','\xfb','\x83','\x87','\xff','\xc3', // 0x0180
    '\x81','\xad','\xa1','\xa3','\xff','\x81','\x83','\xf9', // 0x0188
    '\xfd','\xff','\xc3','\x81','\xad','\xa1','\xa3','\xff', // 0x0190
    '\xff','\x04','\x8f','\x83','\xe0','\xec','\xe0','\x83', // 0x0198
    '\x8f','\xff','\xff','\x02','\x80','\x80','\x02','\xe6', // 0x01a0
    '\xc6','\x80','\x91','\xff','\xff','\x02','\x80','\x80', // 0x01a8
    '\x02','\xb6','\xb6','\x04','\xff','\xff','\x03','\x00', // 0x01b0
    '\x7f','\xd5','\xff','\xaa','\xff','\x55','\xff','\xaa', // 0x01b8
    '\xff','\x60','\xc8','\xd0','\xa8','\x94','\x2a','\x54', // 0x01c0
    '\xaa','\x00','\xff','\xaa','\xff','\x55','\xff','\xaa', // 0x01c8
    '\xff','\x55','\xff','\xaa','\xff','\x55','\xff','\x00', // 0x01d0
    '\x00','\x1e','\xff','\xff','\x09','\x0f','\x1f','\xef', // 0x01d8
    '\xef','\x02','\x0f','\x1f','\xff','\x1f','\x0f','\xef', // 0x01e0
    '\xef','\x02','\x0f','\x1f','\xff','\xff','\x04','\x0f', // 0x01e8
    '\x1f','\xcf','\xef','\xff','\x0f','\x0f','\x02','\xff', // 0x01f0
    '\xff','\x02','\x0f','\x0f','\x02','\xff','\x07','\x07', // 0x01f8
    '\x02','\xff','\x1f','\x0f','\x6f','\x0f','\x1f','\xff', // 0x0200
    '\x9f','\x0f','\x2f','\x6f','\x6f','\x02','\xff','\xff', // 0x0208
    '\x02','\xe7','\xff','\xe7','\xff','\xff','\x0b','\xfe', // 0x0210
    '\xfe','\x02','\xfd','\xfd','\x02','\xfb','\xfb','\x02', // 0x0218
    '\xf6','\xf7','\xed','\xef','\xda','\xdf','\xb5','\xbf', // 0x0220
    '\x6b','\x7e','\xd6','\xff','\xaa','\xff','\x55','\xff', // 0x0228
    '\xaa','\xff','\x55','\xff','\xaa','\xff','\x55','\xff', // 0x0230
    '\x00','\x00','\x10','\x80','\x80','\x02','\xc0','\xc0', // 0x0238
    '\x02','\xe0','\xe0','\x02','\xf0','\xf0','\x02','\xf8', // 0x0240
    '\xf8','\x02','\xfc','\xfc','\x02','\xfe','\xfe','\x02', // 0x0248
    '\xff','\xff','\x09','\xfc','\xfc','\x02','\xff','\xff', // 0x0250
    '\x02','\xfc','\xfc','\x02','\xff','\xfe','\xfc','\xfd', // 0x0258
    '\xfd','\x02','\xfc','\xfe','\xff','\xff','\x04','\xfc', // 0x0260
    '\xfc','\x02','\xff','\xff','\x03','\xfe','\xfc','\xfd', // 0x0268
    '\xfd','\x02','\xfe','\xfc','\xff','\xfc','\xfc','\x02', // 0x0270
    '\xff','\xfe','\xfc','\xfd','\xfd','\x03','\xff','\xfd', // 0x0278
    '\xfd','\x03','\xfc','\xfe','\xff','\xff','\x20','\xfe', // 0x0280
    '\xfe','\x02','\xfd','\xfd','\x02','\xfb','\xfb','\x02', // 0x0288
    '\xf6','\xf7','\xed','\xef','\xda','\xdf','\xb5','\xbf', // 0x0290
    '\x80','\x80','\x02','\xc0','\xc0','\x02','\xe0','\xe0', // 0x0298
    '\x02','\xf0','\xf0','\x02','\xf8','\xf8','\x02','\xfc', // 0x02a0
    '\xfc','\x02','\xfe','\xfe','\x02','\xff','\xff','\x51', // 0x02a8
    */
    /*
// ohm pie
    '\xff','\xff','\x11','\x7f','\x7f','\x05','\x3f','\x3f', // 0x0008
    '\x05','\x1f','\x3f','\x3f','\x03','\x7f','\x7f','\x05', // 0x0010
    '\xff','\xff','\x30','\x7f','\x7f','\x02','\x3f','\x9f', // 0x0018
    '\x9f','\x02','\x3f','\xbf','\xbf','\x02','\x1f','\xdf', // 0x0020
    '\x9f','\xdf','\x2f','\xe7','\x07','\xff','\xff','\x23', // 0x0028
    '\x3f','\x1f','\x0f','\x07','\x07','\x02','\x03','\x01', // 0x0030
    '\x01','\x02','\x80','\xc0','\xc0','\x02','\xe0','\xe0', // 0x0038
    '\x02','\xf0','\xf0','\x04','\xf8','\xf8','\x07','\xf0', // 0x0040
    '\xf0','\x04','\xe0','\xe0','\x02','\xc0','\xc0','\x02', // 0x0048
    '\x80','\x01','\x01','\x02','\x03','\x07','\x07','\x02', // 0x0050
    '\x0f','\x1f','\x3f','\xff','\xff','\x0a','\x7f','\x7f', // 0x0058
    '\x04','\xbf','\xbf','\x05','\x3f','\xbf','\x9f','\x4f', // 0x0060
    '\xe7','\xd3','\xb9','\x55','\xba','\xee','\x34','\xea', // 0x0068
    '\xbe','\xd2','\xac','\x76','\x9a','\xec','\x36','\xed', // 0x0070
    '\x57','\x3a','\x6d','\x57','\x3a','\xad','\x97','\xba', // 0x0078
    '\xad','\x96','\x8b','\xdd','\x80','\xbf','\x3f','\x7f', // 0x0080
    '\x7f','\x02','\xff','\xff','\x1b','\x3f','\x07','\x01', // 0x0088
    '\x00','\x00','\x05','\xe0','\xf8','\xfe','\xff','\xff', // 0x0090
    '\x1b','\xfe','\xf8','\xe0','\x00','\x00','\x05','\x01', // 0x0098
    '\x07','\x3f','\xff','\xff','\x03','\xe7','\x81','\x3c', // 0x00a0
    '\x6a','\xd6','\x3b','\xed','\xd2','\x7f','\xd4','\x6b', // 0x00a8
    '\xbe','\x65','\x5b','\x36','\x2d','\x9b','\x96','\xc9', // 0x00b0
    '\x5f','\xa2','\xef','\xa5','\xf3','\x52','\xeb','\x78', // 0x00b8
    '\xa9','\xfd','\x54','\xfc','\x56','\xfe','\xea','\xbf', // 0x00c0
    '\xf5','\xdf','\xfd','\xb7','\xfe','\xef','\xbb','\xfe', // 0x00c8
    '\xef','\x7f','\xfb','\xdf','\xfe','\xfe','\x02','\x7c', // 0x00d0
    '\xf9','\xf3','\xf3','\x02','\x67','\xe7','\xcf','\x9f', // 0x00d8
    '\x1f','\x3f','\x7f','\xff','\xff','\x10','\x80','\x00', // 0x00e0
    '\x00','\x06','\x0e','\xff','\xff','\x21','\x0e','\x00', // 0x00e8
    '\x00','\x06','\x80','\xff','\xff','\x06','\xfe','\xfd', // 0x00f0
    '\xf9','\x02','\xeb','\xbd','\x00','\x01','\x00','\x02', // 0x00f8
    '\x02','\x02','\x03','\x05','\x07','\x02','\x07','\x05', // 0x0100
    '\x07','\x05','\x06','\x07','\x0d','\x07','\x0d','\x07', // 0x0108
    '\x0d','\x07','\x0d','\x0f','\x1b','\x0e','\x9b','\x1e', // 0x0110
    '\x17','\x1e','\x1b','\x3f','\x2e','\x3b','\x3f','\x1f', // 0x0118
    '\x3b','\x3f','\x3f','\x02','\x7b','\x7f','\x7f','\x07', // 0x0120
    '\xff','\xff','\x04','\xfe','\xfc','\xf9','\xf9','\x02', // 0x0128
    '\xf3','\xe7','\xcf','\xcf','\x02','\x9f','\x3f','\x7f', // 0x0130
    '\xff','\xff','\x07','\xfc','\xf0','\xc0','\x80','\x00', // 0x0138
    '\x00','\x04','\x07','\x1f','\x3f','\x7f','\xff','\xff', // 0x0140
    '\x17','\x7f','\x3f','\x1f','\x07','\x00','\x00','\x04', // 0x0148
    '\x80','\xc0','\xf0','\xfc','\xff','\xff','\x0a','\xfe', // 0x0150
    '\xc0','\x0f','\xfc','\x80','\x00','\x00','\x10','\x02', // 0x0158
    '\x40','\x00','\x08','\x01','\x20','\x04','\x00','\x20', // 0x0160
    '\x82','\x08','\x01','\x50','\x04','\x81','\x28','\x42', // 0x0168
    '\x01','\xa8','\x12','\x80','\x2a','\x00','\x25','\x40', // 0x0170
    '\x8a','\x20','\x10','\x42','\x14','\x80','\x0a','\x54', // 0x0178
    '\x00','\x5a','\x00','\x6a','\x04','\xb1','\x45','\x11', // 0x0180
    '\xad','\x40','\x34','\x01','\x03','\xff','\xff','\x02', // 0x0188
    '\x1f','\x1f','\x07','\x1e','\x1c','\x18','\x10','\x00', // 0x0190
    '\x00','\x04','\x01','\x03','\x07','\x07','\x02','\x0f', // 0x0198
    '\x0f','\x02','\x1f','\xff','\xff','\x07','\x1f','\x0f', // 0x01a0
    '\x0f','\x02','\x07','\x07','\x02','\x03','\x01','\x00', // 0x01a8
    '\x00','\x04','\x10','\x18','\x1c','\x1e','\x1f','\x1f', // 0x01b0
    '\x07','\xff','\xff','\x0a','\xfe','\xe0','\x8f','\x38', // 0x01b8
    '\xc0','\x80','\x80','\x08','\x00','\x00','\x03','\x40', // 0x01c0
    '\x00','\x02','\x40','\x00','\x08','\x01','\x40','\x08', // 0x01c8
    '\x01','\x20','\x04','\x40','\x10','\x85','\x00','\x48', // 0x01d0
    '\x02','\x50','\x02','\x24','\x90','\x02','\x54','\x01', // 0x01d8
    '\x10','\x45','\x08','\xa0','\x1a','\x41','\x14','\x22', // 0x01e0
    '\x90','\x0a','\x50','\x05','\xa8','\x53','\x04','\xa9', // 0x01e8
    '\x44','\x12','\x69','\x84','\x32','\x4d','\x00','\x00', // 0x01f0
    '\x02','\xff','\xff','\x02','\xfc','\xfc','\x16','\xff', // 0x01f8
    '\xff','\x07','\xfc','\xfc','\x16','\xff','\xff','\x0d', // 0x0200
    '\xfe','\xfe','\x06','\xfc','\xfc','\x02','\xfd','\xfd', // 0x0208
    '\x06','\xf9','\xfb','\xfa','\xfa','\x07','\xf2','\xf6', // 0x0210
    '\xf6','\x02','\xf4','\xf4','\x05','\xe4','\xe5','\xe8', // 0x0218
    '\xe8','\x04','\xe9','\xc8','\xd9','\xd8','\xd2','\xd0', // 0x0220
    '\xd4','\xd1','\x94','\xb0','\xa2','\xa1','\xa4','\xa2', // 0x0228
    '\xa0','\x25','\x2a','\x60','\x4b','\x44','\x41','\x4a', // 0x0230
    '\x45','\x00','\xf0','\xff','\xff','\x81',
*/
/*
// electronica mystica
    '\x00','\x00','\x10','\xfc','\xfc','\x02','\x00','\x00', // 0x0008
    '\x20','\x60','\x60','\x04','\xff','\xfe','\x60','\x60', // 0x0010
    '\x04','\x00','\x00','\x26','\xe0','\x60','\x00','\x00', // 0x0018
    '\x1d','\xfe','\xff','\x1b','\x1b','\x02','\x3b','\x3b', // 0x0020
    '\x02','\x33','\x33','\x04','\x3f','\x3f','\x03','\x00', // 0x0028
    '\x00','\x02','\xff','\xff','\x02','\x00','\x00','\x04', // 0x0030
    '\xfe','\xff','\x1b','\x1b','\x02','\x3b','\x3b','\x02', // 0x0038
    '\x33','\x33','\x05','\x3f','\x3f','\x02','\x00','\x00', // 0x0040
    '\x02','\xf8','\xf8','\x02','\x1c','\x0c','\x0c','\x07', // 0x0048
    '\x00','\x00','\x07','\xff','\xff','\x02','\x00','\x00', // 0x0050
    '\x06','\xf8','\xfe','\x0c','\x0c','\x05','\x3c','\x3c', // 0x0058
    '\x02','\x00','\x00','\x02','\xf8','\xf8','\x02','\x88', // 0x0060
    '\x0c','\x0c','\x07','\xfc','\xf8','\x00','\x00','\x02', // 0x0068
    '\xff','\xff','\x02','\x0c','\x0c','\x05','\xfc','\xfc', // 0x0070
    '\x02','\x00','\x00','\x02','\xfc','\xfc','\x02','\x00', // 0x0078
    '\x00','\x03','\xf8','\xfc','\x0c','\x0c','\x07','\x00', // 0x0080
    '\x00','\x03','\xfc','\xfc','\x02','\x0c','\x0c','\x07', // 0x0088
    '\xfc','\xf8','\x00','\x00','\x03','\x0f','\x0f','\x02', // 0x0090
    '\x0e','\x0c','\x0c','\x09','\x04','\x00','\x00','\x02', // 0x0098
    '\x07','\x0f','\x0c','\x0c','\x02','\x00','\x00','\x02', // 0x00a0
    '\x07','\x0f','\x0e','\x0c','\x0c','\x09','\x04','\x00', // 0x00a8
    '\x00','\x02','\x03','\x07','\x07','\x02','\x0e','\x0e', // 0x00b0
    '\x02','\x0c','\x0c','\x06','\x00','\x00','\x06','\x07', // 0x00b8
    '\x1f','\x00','\x00','\x06','\x1f','\x1f','\x02','\x00', // 0x00c0
    '\x00','\x09','\x07','\x1f','\x1f','\x02','\x18','\x18', // 0x00c8
    '\x05','\x1c','\x1c','\x02','\x1f','\x0f','\x00','\x00', // 0x00d0
    '\x02','\x0f','\x0f','\x02','\xc0','\x80','\x00','\x00', // 0x00d8
    '\x03','\x1f','\x1f','\x02','\x00','\x00','\x02','\x1f', // 0x00e0
    '\x0f','\x00','\x00','\x03','\x07','\x07','\x02','\x0e', // 0x00e8
    '\x0e','\x02','\x0c','\x0c','\x06','\x00','\x00','\x02', // 0x00f0
    '\x07','\x0f','\x0e','\x0c','\x0c','\x06','\x0f','\x0f', // 0x00f8
    '\x02','\x0e','\x07','\x00','\x00','\x2f','\x80','\x80', // 0x0100
    '\x02','\xc0','\xc0','\x0b','\x00','\x00','\x0c','\x80', // 0x0108
    '\x00','\x00','\x03','\x80','\x80','\x07','\x00','\x00', // 0x0110
    '\x03','\x0c','\x0c','\x03','\xff','\xff','\x02','\x0c', // 0x0118
    '\x0c','\x04','\x00','\x00','\x03','\x9c','\x8c','\x00', // 0x0120
    '\x00','\x04','\x80','\x80','\x08','\x00','\x00','\x03', // 0x0128
    '\x80','\x80','\x0a','\x00','\x00','\x32','\xff','\xff', // 0x0130
    '\x02','\x01','\x00','\x00','\x03','\xff','\xff','\x02', // 0x0138
    '\x00','\x00','\x04','\xff','\xfe','\x00','\x00','\x02', // 0x0140
    '\xff','\xfe','\x80','\x80','\x06','\xff','\xff','\x02', // 0x0148
    '\x00','\x00','\x03','\x1f','\x1f','\x02','\x19','\x19', // 0x0150
    '\x03','\xf8','\xf8','\x02','\x00','\x00','\x06','\xff', // 0x0158
    '\xff','\x02','\x00','\x00','\x07','\xff','\xff','\x02', // 0x0160
    '\x00','\x00','\x03','\xff','\xff','\x02','\xc1','\xc1', // 0x0168
    '\x03','\x81','\x81','\x04','\x80','\x00','\x00','\x02', // 0x0170
    '\xff','\xff','\x02','\xc1','\x81','\x81','\x06','\xff', // 0x0178
    '\xff','\x02','\x80','\xe0','\x00','\x00','\x2f','\x01', // 0x0180
    '\x00','\x00','\x05','\x01','\x01','\x02','\x00','\x00', // 0x0188
    '\x04','\x01','\x01','\x02','\x00','\x00','\x02','\x01', // 0x0190
    '\xe1','\xc1','\x81','\x81','\x05','\xff','\xff','\x02', // 0x0198
    '\x00','\x00','\x02','\x02','\x03','\x03','\x07','\x00', // 0x01a0
    '\x00','\x06','\x01','\x03','\x00','\x00','\x07','\x03', // 0x01a8
    '\x01','\x00','\x00','\x05','\x01','\x01','\x08','\x00', // 0x01b0
    '\x00','\x03','\x01','\x01','\x0b','\x00','\x00','\x41', // 0x01b8
    '\x01','\x01','\x09','\x00','\x00','\xb7',*/
/*
//const unsigned char leopardrov[] = {
    '\x00','\x00','\x22','\x80','\x80','\x02','\x40','\x80', // 0x0008
    '\x60','\xc0','\x20','\xf0','\x10','\xe0','\x38','\xc8', // 0x0010
    '\x30','\xd8','\x28','\xdc','\x24','\xb8','\x4e','\x30', // 0x0018
    '\xde','\x24','\x5a','\x2e','\xd0','\x1e','\xe2','\x1e', // 0x0020
    '\x69','\x96','\x6d','\x13','\xae','\x29','\x96','\x2a', // 0x0028
    '\x6c','\x12','\xae','\x68','\x96','\x2c','\xda','\x24', // 0x0030
    '\xbc','\x44','\xb8','\x6c','\x90','\x68','\x98','\x70', // 0x0038
    '\x80','\x70','\x90','\x60','\xa0','\x40','\x40','\x03', // 0x0040
    '\x80','\x00','\x00','\x37','\x80','\x00','\x60','\x00', // 0x0048
    '\xb0','\x08','\x58','\x06','\x28','\x56','\x03','\xac', // 0x0050
    '\x03','\x48','\x97','\x40','\x0b','\x54','\x81','\x2a', // 0x0058
    '\x85','\x20','\x8b','\x50','\x82','\xd5','\x00','\xaa', // 0x0060
    '\x50','\xc2','\xd5','\xc0','\xea','\xe0','\xf5','\xe0', // 0x0068
    '\xea','\xf4','\xf0','\xf5','\xf0','\xfc','\x79','\xf8', // 0x0070
    '\x7a','\xf8','\x7c','\x3a','\x3d','\x3c','\xbe','\x7c', // 0x0078
    '\xa2','\x5f','\xbf','\xff','\x7f','\xff','\x0f','\xfd', // 0x0080
    '\x52','\x09','\xf0','\x02','\x44','\x80','\x25','\x00', // 0x0088
    '\xc2','\x05','\x81','\x09','\x02','\x25','\x01','\x16', // 0x0090
    '\x01','\x2e','\x00','\x2c','\x00','\x30','\x80','\x60', // 0x0098
    '\x00','\x80','\x00','\x00','\x25','\x40','\x10','\x00', // 0x00a0
    '\x15','\x80','\xca','\x70','\xa5','\x70','\x5a','\x38', // 0x00a8
    '\xca','\x7d','\x54','\xff','\xaa','\xff','\x5d','\xff', // 0x00b0
    '\xff','\x03','\xfe','\xff','\x7d','\x5f','\xbf','\x1e', // 0x00b8
    '\x5b','\x0f','\xbe','\x53','\x0d','\xa7','\x16','\x43', // 0x00c0
    '\x97','\x83','\xeb','\xc3','\x75','\xe9','\xbd','\x5b', // 0x00c8
    '\x6e','\xbe','\x4b','\x37','\x55','\x1d','\xc1','\x2e', // 0x00d0
    '\xc2','\x2a','\x93','\x4c','\x37','\x82','\x5b','\x84', // 0x00d8
    '\x6b','\xf4','\x13','\xff','\x48','\x7e','\x59','\xbc', // 0x00e0
    '\x5a','\x9d','\xe0','\xaa','\xe0','\x7d','\xbc','\xd6', // 0x00e8
    '\xef','\xf3','\x7d','\xc1','\x04','\x00','\x00','\x0b', // 0x00f0
    '\x02','\x00','\x00','\x02','\x08','\x20','\xc0','\x00', // 0x00f8
    '\x00','\x1c','\x80','\xc0','\x60','\x38','\x8c','\x66', // 0x0100
    '\x3b','\x86','\xe3','\x31','\x9c','\x06','\xf3','\x3a', // 0x0108
    '\x87','\xe1','\x7e','\xeb','\x1e','\x01','\x01','\x02', // 0x0110
    '\x09','\x04','\x01','\x00','\x22','\x01','\x00','\x20', // 0x0118
    '\x81','\x80','\xe0','\x70','\xe9','\x78','\xb8','\x6e', // 0x0120
    '\x9e','\x77','\x9a','\x6b','\x95','\xca','\xf5','\x02', // 0x0128
    '\xf9','\x15','\xe8','\x15','\x66','\x19','\xa5','\x1a', // 0x0130
    '\x46','\x91','\x6c','\x81','\xfa','\xa5','\x6a','\xf5', // 0x0138
    '\x1a','\xed','\x96','\xab','\xf5','\xb5','\xf5','\xda', // 0x0140
    '\x7d','\xb6','\xdf','\xf6','\xdb','\xfd','\xff','\xff', // 0x0148
    '\x02','\x57','\x83','\x55','\x00','\x02','\x00','\x00', // 0x0150
    '\x12','\x03','\x20','\x00','\x00','\x19','\x02','\x03', // 0x0158
    '\xa0','\x78','\x0f','\x81','\xe8','\x3e','\x01','\x80', // 0x0160
    '\xfc','\x07','\xb9','\xff','\xa0','\xfa','\x5f','\xfd', // 0x0168
    '\x01','\x00','\x04','\x00','\x00','\x03','\x01','\x10', // 0x0170
    '\x00','\x02','\x40','\xfc','\x6e','\xfb','\xff','\xed', // 0x0178
    '\xd9','\xf8','\xda','\xfd','\xf3','\xf8','\xfb','\xfc', // 0x0180
    '\xfb','\xfd','\xf9','\x76','\x39','\x7a','\xf2','\xfd', // 0x0188
    '\xf2','\xff','\xea','\xff','\xfb','\xff','\xff','\x03', // 0x0190
    '\xef','\xff','\x9f','\xf4','\x6f','\xff','\x6a','\x5f', // 0x0198
    '\xba','\xff','\xfd','\x7e','\x5f','\x3f','\xff','\xff', // 0x01a0
    '\x02','\xf7','\xff','\xff','\x02','\x02','\x68','\x05', // 0x01a8
    '\x00','\x04','\x08','\x00','\x08','\x00','\x08','\x00', // 0x01b0
    '\x00','\x02','\x08','\x00','\x00','\x03','\x08','\x00', // 0x01b8
    '\x08','\x00','\x00','\x02','\x10','\x00','\x00','\x02', // 0x01c0
    '\x80','\x12','\x00','\x00','\x1b','\x01','\x00','\x08', // 0x01c8
    '\x3e','\x05','\x00','\x00','\x02','\xfb','\xff','\x00', // 0x01d0
    '\x2a','\xef','\xba','\xff','\x45','\xff','\x00','\x00', // 0x01d8
    '\x07','\x10','\xe0','\x00','\x00','\x02','\x0b','\x0f', // 0x01e0
    '\x0d','\x3f','\x13','\x2b','\x37','\x63','\x5f','\x27', // 0x01e8
    '\xa7','\x46','\x0f','\x0f','\x04','\x1c','\x18','\x18', // 0x01f0
    '\x02','\x3c','\x3f','\x3f','\x04','\x7f','\x3f','\x7f', // 0x01f8
    '\x7f','\x02','\x7d','\xfa','\xff','\xad','\xfb','\xdf', // 0x0200
    '\x77','\x1f','\xa1','\xfe','\x3f','\x5d','\x01','\xfc', // 0x0208
    '\x32','\x5f','\x07','\x0b','\x01','\x00','\x00','\x11', // 0x0210
    '\x80','\x00','\x80','\x80','\x02','\x50','\x20','\x18', // 0x0218
    '\x06','\x01','\x00','\x00','\x23','\x03','\x07','\x04', // 0x0220
    '\x02','\x3f','\x3e','\x6f','\xfd','\xbf','\xf4','\x40', // 0x0228
    '\xa0','\x10','\x40','\x80','\x20','\x43','\x02','\xaf', // 0x0230
    '\xfd','\xd6','\xb0','\xf8','\x40','\x00','\x80','\x00', // 0x0238
    '\x00','\x19','\x03','\x06','\x0b','\x0f','\x0c','\x0b', // 0x0240
    '\x97','\x1d','\x10','\x85','\x00','\x80','\x00','\x40', // 0x0248
    '\x80','\x50','\x00','\xa0','\x00','\x50','\x80','\x28', // 0x0250
    '\x80','\x50','\x84','\xa0','\x52','\x40','\x74','\x00', // 0x0258
    '\x3a','\x10','\x0a','\x04','\x04','\x02','\x01','\x00', // 0x0260
    '\x00','\x32','\x01','\x01','\x02','\x00','\x03','\x01', // 0x0268
    '\x06','\x05','\x0a','\x05','\x0a','\x1d','\x0b','\x3e', // 0x0270
    '\x37','\x2d','\x3a','\x14','\x2a','\x75','\x48','\x75', // 0x0278
    '\x08','\xf5','\x48','\xb5','\xc8','\x32','\xcd','\x70', // 0x0280
    '\x86','\xf8','\x42','\xbd','\xc0','\x3a','\xc4','\x6a', // 0x0288
    '\xd8','\x25','\xd8','\x62','\x9d','\xe0','\x5a','\xb5', // 0x0290
    '\x48','\x75','\x14','\x7a','\x45','\x3a','\x24','\x1a', // 0x0298
    '\x2a','\x35','\x0a','\x14','\x0b','\x0c','\x02','\x0d', // 0x02a0
    '\x02','\x05','\x02','\x01','\x02','\x01','\x00','\x00', // 0x02a8
    '\x1e',*/
