; XMEGA Oscilloscope and Development Kit
;
; Gabotronics
; March 2012
;
; Copyright 2012 Gabriel Anzziani
;
; This program is distributed under the terms of the GNU General Public License
;
; www.gabotronics.com
; email me at: gabriel@gabotronics.com

#include <avr/io.h>

;----------------------------------------------------------------------------;
; ADD with Saturation
.global addwsat     ; uint8_t addwsat(uint8_t a, int8_t b);
addwsat:
    subi R24, 0x80  ; Transform [0x00, 0xff] -> [0x80, 0x7f]
.global saddwsat    ; uint8_t saddwsat(int8_t a, int8_t b);
saddwsat:
    add  R24, R22   ; add
    brvc 0f
    ; Signed overflow -> load MAX
    ldi  R24, 0x7f
    sbrc R22, 7
    ; R22 is negative -> load MIN
    ldi  R24, 0x80
    0:
    subi R24, 0x80  ; Back-Transform [0x80, 0x7f] -> [0x00, 0xff]
    ret

; Digital Trigger Rising Edge
;----------------------------------------------------------------------------;
;
.global trigupCHD
.func trigupCHD
trigupCHD:
    ldi ZL, lo8(pm(tableup))
    ldi ZH, hi8(pm(tableup))
    add ZL, r24
    adc ZH, r1
    ijmp
tableup:
    rjmp trigpc0
    rjmp trigpc1
    rjmp trigpc2
    rjmp trigpc3
    rjmp trigpc4
    rjmp trigpc5
    rjmp trigpc6
    rjmp trigpc7
    rjmp trigpd5
.endfunc

; trigger on PC0
;----------------------------------------------------------------------------;
;
.global trigpc0
.func trigpc0
trigpc0:
    sbic    0x000B,0        ; 2 cycle ; Status update? (GPIOB)
    ret
    sbic    0x001A,0        ; Check if bit VPORT2.0 is low
    rjmp    trigpc0
0:
    sbic    0x000B,0        ; 2 cycle ; Status update? (GPIOB)
    ret
    sbis    0x001A,0        ; Check if bit VPORT2.0 is high
    rjmp    0b
    rjmp    post
.endfunc

; trigger on PC1
;----------------------------------------------------------------------------;
;
.global trigpc1
.func trigpc1
trigpc1:
    sbic    0x000B,0        ; 2 cycle ; Status update? (GPIOB)
    ret
    sbic    0x001A,1        ; Check if bit VPORT2.1 is low
    rjmp    trigpc1
0:
    sbic    0x000B,0        ; 2 cycle ; Status update? (GPIOB)
    ret
    sbis    0x001A,1        ; Check if bit VPORT2.1 is high
    rjmp    0b
    rjmp    post
.endfunc

; trigger on PC2
;----------------------------------------------------------------------------;
;
.global trigpc2
.func trigpc2
trigpc2:
    sbic    0x000B,0        ; 2 cycle ; Status update? (GPIOB)
    ret
    sbic    0x001A,2        ; Check if bit VPORT2.1 is low
    rjmp    trigpc2
0:
    sbic    0x000B,0        ; 2 cycle ; Status update? (GPIOB)
    ret
    sbis    0x001A,2        ; Check if bit VPORT2.1 is high
    rjmp    0b
    rjmp    post
.endfunc

; trigger on PC3
;----------------------------------------------------------------------------;
;
.global trigpc3
.func trigpc3
trigpc3:
    sbic    0x000B,0        ; 2 cycle ; Status update? (GPIOB)
    ret
    sbic    0x001A,3        ; Check if bit VPORT2.1 is low
    rjmp    trigpc3
0:
    sbic    0x000B,0        ; 2 cycle ; Status update? (GPIOB)
    ret
    sbis    0x001A,3        ; Check if bit VPORT2.1 is high
    rjmp    0b
    rjmp    post
.endfunc


; trigger on PC4
;----------------------------------------------------------------------------;
;
.global trigpc4
.func trigpc4
trigpc4:
    sbic    0x000B,0        ; 2 cycle ; Status update? (GPIOB)
    ret
    sbic    0x001A,4        ; Check if bit VPORT2.1 is low
    rjmp    trigpc4
0:
    sbic    0x000B,0        ; 2 cycle ; Status update? (GPIOB)
    ret
    sbis    0x001A,4        ; Check if bit VPORT2.1 is high
    rjmp    0b
    rjmp    post
.endfunc


; trigger on PC5
;----------------------------------------------------------------------------;
;
.global trigpc5
.func trigpc5
trigpc5:
    sbic    0x000B,0        ; 2 cycle ; Status update? (GPIOB)
    ret
    sbic    0x001A,5        ; Check if bit VPORT2.1 is low
    rjmp    trigpc5
0:
    sbic    0x000B,0        ; 2 cycle ; Status update? (GPIOB)
    ret
    sbis    0x001A,5        ; Check if bit VPORT2.1 is high
    rjmp    0b
    rjmp    post
.endfunc


; trigger on PC6
;----------------------------------------------------------------------------;
;
.global trigpc6
.func trigpc6
trigpc6:
    sbic    0x000B,0        ; 2 cycle ; Status update? (GPIOB)
    ret
    sbic    0x001A,6        ; Check if bit VPORT2.1 is low
    rjmp    trigpc6
0:
    sbic    0x000B,0        ; 2 cycle ; Status update? (GPIOB)
    ret
    sbis    0x001A,6        ; Check if bit VPORT2.1 is high
    rjmp    0b
    rjmp    post
.endfunc


; trigger on PC7
;----------------------------------------------------------------------------;
;
.global trigpc7
.func trigpc7
trigpc7:
    sbic    0x000B,0        ; 2 cycle ; Status update? (GPIOB)
    ret
    sbic    0x001A,7        ; Check if bit VPORT2.1 is low
    rjmp    trigpc7
0:
    sbic    0x000B,0        ; 2 cycle ; Status update? (GPIOB)
    ret
    sbis    0x001A,7        ; Check if bit VPORT2.1 is high
    rjmp    0b
    rjmp    post
.endfunc

; trigger on PD5 (external trigger)
;----------------------------------------------------------------------------;
;
.global trigpd5
.func trigpd5
trigpd5:
    sbic    0x000B,0        ; 2 cycle ; Status update? (GPIOB)
    ret
    sbic    0x001e,5        ; Check if bit VPORT3.5 is low
    rjmp    trigpd5
0:
    sbic    0x000B,0        ; 2 cycle ; Status update? (GPIOB)
    ret
    sbis    0x001e,5        ; Check if bit VPORT3.5 is high
    rjmp    0b
    rjmp    post
.endfunc

; Digital Trigger Rising Edge
;----------------------------------------------------------------------------;
;
.global trigdownCHD
.func trigdownCHD
trigdownCHD:
    ldi ZL, lo8(pm(tabledown))
    ldi ZH, hi8(pm(tabledown))
    add ZL, r24
    adc ZH, r1
    ijmp
tabledown:
    rjmp trigpc0d
    rjmp trigpc1d
    rjmp trigpc2d
    rjmp trigpc3d
    rjmp trigpc4d
    rjmp trigpc5d
    rjmp trigpc6d
    rjmp trigpc7d
    rjmp trigpd5d
.endfunc

; trigger on PC0
;----------------------------------------------------------------------------;
;
.global trigpc0d
.func trigpc0d
trigpc0d:
    sbic    0x000B,0        ; 2 cycle ; Status update? (GPIOB)
    ret
    sbis    0x001A,0        ; Check if bit VPORT2.0 is high
    rjmp    trigpc0d
0:
    sbic    0x000B,0        ; 2 cycle ; Status update? (GPIOB)
    ret
    sbic    0x001A,0        ; Check if bit VPORT2.0 is low
    rjmp    0b
    rjmp    post
.endfunc

; trigger on PC1
;----------------------------------------------------------------------------;
;
.global trigpc1d
.func trigpc1d
trigpc1d:
    sbic    0x000B,0        ; 2 cycle ; Status update? (GPIOB)
    ret
    sbis    0x001A,1        ; Check if bit VPORT2.1 is high
    rjmp    trigpc1d
0:
    sbic    0x000B,0        ; 2 cycle ; Status update? (GPIOB)
    ret
    sbic    0x001A,1        ; Check if bit VPORT2.1 is low
    rjmp    0b
    rjmp    post
.endfunc

; trigger on PC2
;----------------------------------------------------------------------------;
;
.global trigpc2d
.func trigpc2d
trigpc2d:
    sbic    0x000B,0        ; 2 cycle ; Status update? (GPIOB)
    ret
    sbis    0x001A,2        ; Check if bit VPORT2.1 is high
    rjmp    trigpc2d
0:
    sbic    0x000B,0        ; 2 cycle ; Status update? (GPIOB)
    ret
    sbic    0x001A,2        ; Check if bit VPORT2.1 is low
    rjmp    0b
    rjmp    post
.endfunc


; trigger on PC3
;----------------------------------------------------------------------------;
;
.global trigpc3d
.func trigpc3d
trigpc3d:
    sbic    0x000B,0        ; 2 cycle ; Status update? (GPIOB)
    ret
    sbis    0x001A,3        ; Check if bit VPORT2.1 is high
    rjmp    trigpc3d
0:
    sbic    0x000B,0        ; 2 cycle ; Status update? (GPIOB)
    ret
    sbic    0x001A,3        ; Check if bit VPORT2.1 is low
    rjmp    0b
    rjmp    post
.endfunc


; trigger on PC4
;----------------------------------------------------------------------------;
;
.global trigpc4d
.func trigpc4d
trigpc4d:
    sbic    0x000B,0        ; 2 cycle ; Status update? (GPIOB)
    ret
    sbis    0x001A,4        ; Check if bit VPORT2.1 is high
    rjmp    trigpc4d
0:
    sbic    0x000B,0        ; 2 cycle ; Status update? (GPIOB)
    ret
    sbic    0x001A,4        ; Check if bit VPORT2.1 is low
    rjmp    0b
    rjmp    post
.endfunc


; trigger on PC5
;----------------------------------------------------------------------------;
;
.global trigpc5d
.func trigpc5d
trigpc5d:
    sbic    0x000B,0        ; 2 cycle ; Status update? (GPIOB)
    ret
    sbis    0x001A,5        ; Check if bit VPORT2.1 is high
    rjmp    trigpc5d
0:
    sbic    0x000B,0        ; 2 cycle ; Status update? (GPIOB)
    ret
    sbic    0x001A,5        ; Check if bit VPORT2.1 is low
    rjmp    0b
    rjmp    post
.endfunc


; trigger on PC6
;----------------------------------------------------------------------------;
;
.global trigpc6d
.func trigpc6d
trigpc6d:
    sbic    0x000B,0        ; 2 cycle ; Status update? (GPIOB)
    ret
    sbis    0x001A,6        ; Check if bit VPORT2.1 is high
    rjmp    trigpc6d
0:
    sbic    0x000B,0        ; 2 cycle ; Status update? (GPIOB)
    ret
    sbic    0x001A,6        ; Check if bit VPORT2.1 is low
    rjmp    0b
    rjmp    post
.endfunc


; trigger on PC7
;----------------------------------------------------------------------------;
;
.global trigpc7d
.func trigpc7d
trigpc7d:
    sbic    0x000B,0        ; 2 cycle ; Status update? (GPIOB)
    ret
    sbis    0x001A,7        ; Check if bit VPORT2.1 is high
    rjmp    trigpc7d
0:
    sbic    0x000B,0        ; 2 cycle ; Status update? (GPIOB)
    ret
    sbic    0x001A,7        ; Check if bit VPORT2.1 is low
    rjmp    0b
    rjmp    post
.endfunc

; trigger on PD5 (external trigger)
;----------------------------------------------------------------------------;
;
.global trigpd5d
.func trigpd5d
trigpd5d:
    sbic    0x000B,0        ; 2 cycle ; Status update? (GPIOB)
    ret
    sbis    0x001e,5        ; Check if bit VPORT3.5 is high
    rjmp    trigpd5d
0:
    sbic    0x000B,0        ; 2 cycle ; Status update? (GPIOB)
    ret
    sbic    0x001e,5        ; Check if bit VPORT3.5 is low
    rjmp    0b
    rjmp    post
.endfunc

; falling edge trigger detect on CH1
;----------------------------------------------------------------------------;
;                 data1  ___.
;                            \
;  triggervalue - - - - - - - \
;                              \.___ data2
;
.global trigdownCH1
.func trigdownCH1
trigdownCH1:
    subi    r24, 0x83       ; Transform [0x00, 0xff] -> [0x80, 0x7f]
                            ; r24 = (signed)(tlevelo - 3)
0:
    lds     r0, 0x0224      ; 2 cycle : r21 = CH0.RESL
    cp      r24, r0         ; 1 cycle ; compare triggervalue with data1
    brge    1f              ; 1 cycle ; next step if tlevelo >= data1
    sbis    0x000B,0        ; 1 cycle ; Status update? (GPIOB)
    rjmp    0b              ; 2 cycles
                            ; 17 cycles
    ret
1:
    subi    r24, 0xFA       ; r24 = (signed)(tlevelo + 3)
2:
    lds     r0,0x0224       ; 2 cycle : r0 = CH0.RESL
    cp      r24,r0          ; 1 cycle ; compare triggervalue with data2
    brlt    post            ; 1 cycle ; finish if tlevelo < data2
    sbis    0x000B,0        ; 1 cycle ; Status update? (GPIOB)
    rjmp    2b              ; 2 cycles
                            ; 17 cycles
    ret
.endfunc

; rising edge trigger detect on CH1
;----------------------------------------------------------------------------;
;                              .___ data2
;                              /
;  triggervalue - - - - - - - /
;                  data1 ___./
;
.global trigupCH1
.func trigupCH1
trigupCH1:
    subi    r24, 0x7D       ; Transform [0x00, 0xff] -> [0x80, 0x7f]
                            ; r24 = (signed)(tlevelo + 3)
0:
    lds     r0, 0x0224      ; 2 cycle : r0 = CH0.RESL
    cp      r24, r0         ; 1 cycle ; compare triggervalue with data1
    brlt    1f              ; 1 cycle ; next step if tlevelo < data1
    sbis    0x000B,0        ; 1 cycle ; Status update? (GPIOB)
    rjmp    0b              ; 2 cycles
                            ; 7 cycles
    ret
1:
    subi    r24, 0x06       ; r24 = (signed)(tlevelo - 3)
2:
    lds     r0,0x0224       ; 2 cycle : r0 = CH0.RESL
    cp      r24,r0          ; 1 cycle ; compare triggervalue with data2
    brge    post            ; 1 cycle ; finish if tlevelo >= data2
    sbis    0x000B,0        ; 1 cycle ; Status update? (GPIOB)
    rjmp    2b              ; 2 cycles
                            ; 7 cycles
    ret
.endfunc

; Post trigger
;----------------------------------------------------------------------------;
;
post:
    ; Start TCC0 and count remaining samples
    LDI     R24,0x09        ; Event CH1 (ADCA CH0 conversion complete)
    STS     0x0800,R24      ; Store 0x09 in TCC0.CTRLA (count ADC event)
    sbi     0x000B, 5       ; Set trigger (GPIOB)
    in      r24, 0x0000     ; load srate (GPIO0) in r24
    cpi     r24,11          ; compare srate with 11
    brcc    1f              ; exit if srate>=11

    LDI     R24,0x14        ; signed mode, NO free run, 8 bit
0:
    lds     R0, 0x080C      ; TCC0.INTFLAGS
    sbrs    R0,0            ; jump if overflow
    rjmp    0b

    STS     0x0A00,R1       ; Stop Timer TCE0 (for srate > 5)
    STS     0x0201,R24      ; Store 0x14 in ADCA.CTRLB (signed mode, NO free run, 8 bit)
1:
    ret

; falling edge trigger detect on CH2
;----------------------------------------------------------------------------;
;                 data1  ___.
;                            \
;  triggervalue - - - - - - - \
;                              \.___ data2
;
.global trigdownCH2
.func trigdownCH2
trigdownCH2:
    subi    r24, 0x83       ; Transform [0x00, 0xff] -> [0x80, 0x7f]
                            ; r24 = (signed)(tlevelo - 3)
0:
    lds     r0, 0x022C      ; 2 cycle : r0 = CH1.RESL
    cp      r24, r0         ; 1 cycle ; compare triggervalue with data1
    brge    1f              ; 1 cycle ; next step if tlevelo >= data1
    sbis    0x000B,0        ; 1 cycle ; Status update? (GPIOB)
    rjmp    0b              ; 2 cycles
                            ; 7 cycles
    ret
1:
    subi    r24, 0xFA        ; r24 = (signed)(tlevelo + 3)
2:
    lds     r0,0x022C       ; 2 cycle : r0 = CH1.RESL
    cp      r24,r0          ; 1 cycle ; compare triggervalue with data2
    brlt    post            ; 1 cycle ; finish if tlevelo < data2
    sbis    0x000B,0        ; 1 cycle ; Status update? (GPIOB)
    rjmp    2b              ; 2 cycles
                            ; 7 cycles
    ret
.endfunc

; rising edge trigger detect on CH2
;----------------------------------------------------------------------------;
;                              .___ data2
;                              /
;  triggervalue - - - - - - - /
;                  data1 ___./
;
.global trigupCH2
.func trigupCH2
trigupCH2:
    subi    r24, 0x7D       ; Transform [0x00, 0xff] -> [0x80, 0x7f]
                            ; r24 = (signed)(tlevelo + 3)
0:
    lds     r0,0x022C       ; 2 cycle : r0 = CH1.RESL
    cp      r24,r0          ; 1 cycle ; compare triggervalue with data1
    brlt    1f              ; 1 cycle ; next step if tlevelo < data1
    sbis    0x000B,0        ; 1 cycle ; Status update? (GPIOB)
    rjmp    0b              ; 2 cycles
                            ; 7 cycles
    ret
1:
    subi     r24, 0x06       ; r24 = (signed)(tlevelo - 3)
2:
    lds     r0,0x022C       ; 2 cycle : r0 = CH1.RESL
    cp      r24,r0          ; 1 cycle ; compare triggervalue with data1
    brge    post            ; 1 cycle ; finish if tlevelo >= data2
    sbis    0x000B,0        ; 1 cycle ; Status update? (GPIOB)
    rjmp    2b              ; 2 cycles
                            ; 7 cycles
    ret
.endfunc

; negative slope trigger detect on CH1
;----------------------------------------------------------------------------;
;                    old ___.
;                            \
;                           ||\
;                           >< \.___ new
;                    triggervalue
.global slopedownCH1
.func slopedownCH1
slopedownCH1:
    push    r23
    lds     r0,0x0224       ; 2 cycle : r0 = CH0.RESL old value
0:
    lds     r23,0x0224      ; 2 cycle : r23 = CH0.RESL
    cp      r0,r23          ; 1 cycle ; determine difference
    mov     r0,r23          ; 1 cycle ; copy new to old
    brlt    2f              ; next if old < new
    sbis    0x000B,0        ; 1 cycle ; Status update? (GPIOB)
    rjmp    0b              ; 2 cycles
                            ; 17 cycles
    pop     r23
    ret
2:
    lds     r23,0x0224      ; 2 cycle : r23 = CH0.RESL
    sub     r0,r23          ; 1 cycle ; determine difference
    cp      r24,r0          ; 1 cycle ; compare with triggervalue
    mov     r0,r23          ; 1 cycle ; copy new to old
    brge    3f              ; 1 cycle ; tlevelo < data ?
    sbis    0x000B,0        ; 1 cycle ; Status update? (GPIOB)
    rjmp    2b              ; 2 cycles
    pop     r23
    ret
.endfunc

; positive slope trigger detect on CH1
;----------------------------------------------------------------------------;
;                              .___ new
;                              /
;                             /||
;                    old ___./ ><
;                           triggervalue
.global slopeupCH1
.func slopeupCH1
slopeupCH1:
    push    r23
    lds     r0,0x0224       ; 2 cycle : r0 = CH0.RESL old value
0:
    lds     r23,0x0224      ; 2 cycle : r1 = CH0.RESL
    cp      r23,r0          ; 1 cycle ; determine difference
    mov     r0,r23          ; 1 cycle ; copy new to old
    brlt    2f              ; next if old > new
    sbis    0x000B,0        ; 1 cycle ; Status update? (GPIOB)
    rjmp    0b              ; 2 cycles
                            ; 17 cycles
    pop     r23
    ret
2:
    lds     r23,0x0224      ; 2 cycle : r1 = CH0.RESL
    sub     r0,r23          ; 1 cycle ; determine difference
    cp      r0,r24          ; 1 cycle ; compare with triggervalue
    mov     r0,r23          ; 1 cycle ; copy new to old
    brge    3f              ; 1 cycle ; tlevelo < data ?
    sbis    0x000B,0        ; 1 cycle ; Status update? (GPIOB)
    rjmp    2b              ; 2 cycles
    pop     r23
    ret
3:  pop     r23
4:  rjmp    post
.endfunc

; negative slope trigger detect on CH2
;----------------------------------------------------------------------------;
;                    old ___.
;                            \
;                           ||\
;                           >< \.___ new
;                    triggervalue
.global slopedownCH2
.func slopedownCH2
slopedownCH2:
    push    r23
    lds     r0,0x022C       ; 2 cycle : r0 = CH1.RESL old value
0:
    lds     r23,0x022C      ; 2 cycle : r23 = CH0.RESL
    cp      r0,r23          ; 1 cycle ; determine difference
    mov     r0,r23          ; 1 cycle ; copy new to old
    brlt    2f              ; next if old + 3 < new
    sbis    0x000B,0        ; 1 cycle ; Status update? (GPIOB)
    rjmp    0b              ; 2 cycles
                            ; 17 cycles
    pop     r23
    ret
2:
    lds     r23,0x022C      ; 2 cycle : r23 = CH1.RESL
    sub     r0,r23          ; 1 cycle ; determine difference
    cp      r24,r0          ; 1 cycle ; compare with triggervalue
    mov     r0,r23          ; 1 cycle ; copy new to old
    brge    3b              ; 1 cycle ; tlevelo < data ?
    sbis    0x000B,0        ; 1 cycle ; Status update? (GPIOB)
    rjmp    2b              ; 2 cycles
    pop     r23
    ret
.endfunc

; positive slope trigger detect on CH2
;----------------------------------------------------------------------------;
;                              .___ new
;                              /
;                             /||
;                    old ___./ ><
;                           triggervalue
.global slopeupCH2
.func slopeupCH2
slopeupCH2:
    push    r23
    lds     r0,0x022C       ; 2 cycle : r0 = CH1.RESL old value
0:
    lds     r23,0x022C      ; 2 cycle : r23 = CH1.RESL
    cp      r23,r0          ; 1 cycle ; determine difference
    mov     r0,r23          ; 1 cycle ; copy new to old
    brlt    2f              ; next if old > new
    sbis    0x000B,0        ; 1 cycle ; Status update? (GPIOB)
    rjmp    0b              ; 2 cycles
                            ; 17 cycles
    pop     r23
    ret
2:
    lds     r23,0x022C      ; 2 cycle : r23 = CH1.RESL
    sub     r0,r23          ; 1 cycle ; determine difference
    cp      r0,r24          ; 1 cycle ; compare with triggervalue
    mov     r0,r23          ; 1 cycle ; copy new to old
    brge    3b              ; 1 cycle ; tlevelo < data ?
    sbis    0x000B,0        ; 1 cycle ; Status update? (GPIOB)
    rjmp    2b              ; 2 cycles
    pop     r23
    ret
.endfunc

; window trigger detect on CH1
;----------------------------------------------------------------------------;
; r22 contains window1, r24 contains window2
.global windowCH1
.func windowCH1
windowCH1:
    subi    r24, 0x80       ; Transform [0x00, 0xff] -> [0x80, 0x7f]
    subi    r22, 0x80       ; Transform [0x00, 0xff] -> [0x80, 0x7f]
0:
    lds     r0, 0x0224      ; 2 cycle : r21 = CH0.RESL
    cp      r24, r0         ; 1 cycle ; compare window1 with data
    brlt    4b              ; 1 cycle ; continue if window1 >= data
    cp      r0,r22          ; 1 cycle ; compare window2 with data
    brlt    4b              ; 1 cycle ; continue if window2 < data
    sbis    0x000B,0        ; 1 cycle ; Status update? (GPIOB)
    rjmp    0b              ; 2 cycles
                            ; 17 cycles
    ret

.endfunc

; window trigger detect on CH2
;----------------------------------------------------------------------------;

.global windowCH2
.func windowCH2
windowCH2:
    subi    r24, 0x80       ; Transform [0x00, 0xff] -> [0x80, 0x7f]
    subi    r22, 0x80       ; Transform [0x00, 0xff] -> [0x80, 0x7f]
0:
    lds     r0, 0x022C      ; 2 cycle : r0 = CH1.RESL
    cp      r24, r0         ; 1 cycle ; compare window1 with data
    brlt    4b              ; 1 cycle ; continue if window1 >= data
    cp      r0,r22          ; 1 cycle ; compare window2 with data
    brlt    4b              ; 1 cycle ; continue if window2 < data
    sbis    0x000B,0        ; 1 cycle ; Status update? (GPIOB)
    rjmp    0b              ; 2 cycles
                            ; 17 cycles
    ret
.endfunc

.section .bss
.global endpoints   // Endpoints configuration tables
.align 2            // Align to word
endpoints:  .dc.b 1,2,3,4,5,6,7,8    ; ep0 out
            .dc.b 1,2,3,4,5,6,7,8    ; ep0 in
            .dc.b 1,2,3,4,5,6,7,8    ; ep1 out
            .dc.b 1,2,3,4,5,6,7,8    ; ep1 in